/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A Hive table identifier.")
public class ApiHiveTable {
    @SerializedName(value="database")
    private String database = null;
    @SerializedName(value="tableName")
    private String tableName = null;

    public ApiHiveTable database(String database) {
        this.database = database;
        return this;
    }

    @Schema(description="Name of the database to which this table belongs.")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public ApiHiveTable tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @Schema(description="Name of the table. When used as input for a replication job, this can be a regular expression that matches several table names. Refer to the Hive documentation for the syntax of regular expressions.")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHiveTable apiHiveTable = (ApiHiveTable)o;
        return Objects.equals(this.database, apiHiveTable.database) && Objects.equals(this.tableName, apiHiveTable.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.tableName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHiveTable {\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

