/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.AttributeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.FieldColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TagColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadAnalyzeTableColumnDisorderException;
import org.apache.iotdb.db.exception.sql.ColumnCreationFailException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.DataNodeSchemaLockManager;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.SchemaLockType;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AlterTableAddColumnTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateTableTask;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.type.InternalTypeManager;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.schemaengine.table.DataNodeTreeViewSchemaUtils;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableHeaderSchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableHeaderSchemaValidator.class);
    private final ClusterConfigTaskExecutor configTaskExecutor = ClusterConfigTaskExecutor.getInstance();
    private final AccessControl accessControl = Coordinator.getInstance().getAccessControl();

    private TableHeaderSchemaValidator() {
    }

    public static TableHeaderSchemaValidator getInstance() {
        return TableHeaderSchemaValidatorHolder.INSTANCE;
    }

    public Optional<TableSchema> validateTableHeaderSchema(String database, TableSchema tableSchema, MPPQueryContext context, boolean allowCreateTable, boolean isStrictTagColumn) throws LoadAnalyzeTableColumnDisorderException {
        DataNodeSchemaLockManager.getInstance().takeReadLock(context, SchemaLockType.VALIDATE_VS_DELETION_TABLE);
        List<ColumnSchema> inputColumnList = tableSchema.getColumns();
        if (inputColumnList == null || inputColumnList.isEmpty()) {
            throw new SemanticException("No column other than Time present, please check the request");
        }
        TsTable table = DataNodeTableCache.getInstance().getTableInWrite(database, tableSchema.getTableName());
        ArrayList<ColumnSchema> missingColumnList = new ArrayList<ColumnSchema>();
        boolean isAutoCreateSchemaEnabled = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled();
        if (table == null) {
            if (allowCreateTable && isAutoCreateSchemaEnabled) {
                this.autoCreateTable(context, database, tableSchema);
                table = DataNodeTableCache.getInstance().getTable(database, tableSchema.getTableName(), false);
                if (table == null) {
                    throw new IllegalStateException("auto create table succeed, but cannot get table schema in current node's DataNodeTableCache, may be caused by concurrently auto creating table");
                }
            } else {
                TableMetadataImpl.throwTableNotExistsException(database, tableSchema.getTableName());
            }
        } else {
            DataNodeTreeViewSchemaUtils.checkTableInWrite(database, table);
            if (isStrictTagColumn) {
                String tagName;
                List realTagColumns = table.getTagColumnSchemaList();
                List<ColumnSchema> incomingTagColumns = tableSchema.getIdColumns();
                if (realTagColumns.size() <= incomingTagColumns.size()) {
                    for (int indexReal = 0; indexReal < realTagColumns.size(); ++indexReal) {
                        tagName = ((TsTableColumnSchema)realTagColumns.get(indexReal)).getColumnName();
                        int indexIncoming = tableSchema.getIndexAmongIdColumns(tagName);
                        if (indexIncoming == indexReal) continue;
                        throw new LoadAnalyzeTableColumnDisorderException(String.format("Can not create table because incoming table has no less tag columns than existing table, and the existing tag columns are not the prefix of the incoming tag columns. Existing tag column: %s, index in existing table: %s, index in incoming table: %s", tagName, indexReal, indexIncoming));
                    }
                } else {
                    for (int indexIncoming = 0; indexIncoming < incomingTagColumns.size(); ++indexIncoming) {
                        tagName = incomingTagColumns.get(indexIncoming).getName();
                        int indexReal = table.getTagColumnOrdinal(tagName);
                        if (indexReal == indexIncoming) continue;
                        throw new LoadAnalyzeTableColumnDisorderException(String.format("Can not create table because existing table has more tag columns than incoming table, and the incoming tag columns are not the prefix of the existing tag columns. Incoming tag column: %s, index in existing table: %s, index in incoming table: %s", tagName, indexReal, indexIncoming));
                    }
                }
            }
        }
        boolean refreshed = false;
        boolean noField = true;
        for (ColumnSchema columnSchema : inputColumnList) {
            TsTableColumnSchema existingColumn = table.getColumnSchema(columnSchema.getName());
            if (Objects.isNull(existingColumn)) {
                if (!refreshed) {
                    refreshed = true;
                    table = DataNodeTableCache.getInstance().getTable(database, tableSchema.getTableName());
                    existingColumn = table.getColumnSchema(columnSchema.getName());
                }
                if (Objects.isNull(existingColumn)) {
                    if (columnSchema.getColumnCategory() == null) {
                        throw new SemanticException(String.format("Unknown column category for %s. Cannot auto create column.", columnSchema.getName()), TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode());
                    }
                    if (columnSchema.getType() == null) {
                        throw new SemanticException(String.format("Unknown column data type for %s. Cannot auto create column.", columnSchema.getName()), TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode());
                    }
                    missingColumnList.add(columnSchema);
                }
                if (!noField || columnSchema.getColumnCategory() == null || columnSchema.getColumnCategory() != TsTableColumnCategory.FIELD) continue;
                noField = false;
                continue;
            }
            if (columnSchema.getColumnCategory() != null && !existingColumn.getColumnCategory().equals((Object)columnSchema.getColumnCategory())) {
                throw new SemanticException(String.format("Wrong category at column %s.", columnSchema.getName()), TSStatusCode.COLUMN_CATEGORY_MISMATCH.getStatusCode());
            }
            if (!noField || existingColumn.getColumnCategory() != TsTableColumnCategory.FIELD) continue;
            noField = false;
        }
        if (noField) {
            throw new SemanticException("No Field column present, please check the request");
        }
        ArrayList<ColumnSchema> resultColumnList = new ArrayList<ColumnSchema>();
        if (!missingColumnList.isEmpty() && isAutoCreateSchemaEnabled) {
            this.autoCreateColumn(database, tableSchema.getTableName(), missingColumnList, context);
            table = DataNodeTableCache.getInstance().getTable(database, tableSchema.getTableName());
        } else if (!missingColumnList.isEmpty() && !IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert()) {
            throw new SemanticException(String.format("Missing columns %s.", missingColumnList.stream().map(ColumnSchema::getName).collect(Collectors.toList())), TSStatusCode.COLUMN_NOT_EXISTS.getStatusCode());
        }
        table.getColumnList().forEach(o -> resultColumnList.add(new ColumnSchema(o.getColumnName(), TypeFactory.getType((TSDataType)o.getDataType()), false, o.getColumnCategory())));
        return Optional.of(new TableSchema(tableSchema.getTableName(), resultColumnList));
    }

    private void autoCreateTable(MPPQueryContext context, String database, TableSchema tableSchema) {
        DataNodeSchemaLockManager.getInstance().releaseReadLock(context);
        TsTable tsTable = new TsTable(tableSchema.getTableName());
        this.addColumnSchema(tableSchema.getColumns(), tsTable);
        this.accessControl.checkCanCreateTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableSchema.getTableName()));
        CreateTableTask createTableTask = new CreateTableTask(tsTable, database, true);
        try {
            ListenableFuture<ConfigTaskResult> future = createTableTask.execute(this.configTaskExecutor);
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            if (result.getStatusCode().getStatusCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(new IoTDBException("Auto create table column failed.", result.getStatusCode().getStatusCode()));
            }
            DataNodeSchemaLockManager.getInstance().takeReadLock(context, SchemaLockType.VALIDATE_VS_DELETION_TABLE);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void addColumnSchema(List<ColumnSchema> columnSchemas, TsTable tsTable) {
        for (ColumnSchema columnSchema : columnSchemas) {
            TsTableColumnCategory category = columnSchema.getColumnCategory();
            if (category == null) {
                throw new ColumnCreationFailException("Cannot create column " + columnSchema.getName() + " category is not provided");
            }
            String columnName = columnSchema.getName();
            if (tsTable.getColumnSchema(columnName) != null) {
                throw new SemanticException(String.format("Columns in table shall not share the same name %s.", columnName));
            }
            TSDataType dataType = InternalTypeManager.getTSDataType(columnSchema.getType());
            if (dataType == null) {
                throw new ColumnCreationFailException("Cannot create column " + columnSchema.getName() + " datatype is not provided");
            }
            tsTable.addColumnSchema(TableHeaderSchemaValidator.generateColumnSchema(category, columnName, dataType, null, null));
        }
    }

    public static TsTableColumnSchema generateColumnSchema(TsTableColumnCategory category, String columnName, TSDataType dataType, @Nullable String comment, String from) {
        FieldColumnSchema schema;
        switch (category) {
            case TAG: {
                if (!TSDataType.STRING.equals((Object)dataType)) {
                    throw new SemanticException("DataType of TAG Column should only be STRING, current is " + dataType);
                }
                schema = new TagColumnSchema(columnName, dataType);
                break;
            }
            case ATTRIBUTE: {
                if (!TSDataType.STRING.equals((Object)dataType)) {
                    throw new SemanticException("DataType of ATTRIBUTE Column should only be STRING, current is " + dataType);
                }
                schema = new AttributeColumnSchema(columnName, dataType);
                break;
            }
            case TIME: {
                throw new SemanticException("Create table or add column statement shall not specify column category TIME");
            }
            case FIELD: {
                FieldColumnSchema fieldColumnSchema = schema = dataType != TSDataType.UNKNOWN ? new FieldColumnSchema(columnName, dataType, EncodingInferenceUtils.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor(dataType)) : new FieldColumnSchema(columnName, dataType);
                if (!Objects.nonNull(from)) break;
                TreeViewSchema.setOriginalName((TsTableColumnSchema)schema, (String)from);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (Objects.nonNull(comment)) {
            schema.getProps().put("__comment", comment);
        }
        return schema;
    }

    private void autoCreateColumn(String database, String tableName, List<ColumnSchema> inputColumnList, MPPQueryContext context) {
        DataNodeSchemaLockManager.getInstance().releaseReadLock(context);
        this.accessControl.checkCanAlterTable(context.getSession().getUserName(), new QualifiedObjectName(database, tableName));
        AlterTableAddColumnTask task = new AlterTableAddColumnTask(database, tableName, this.parseInputColumnSchema(inputColumnList), context.getQueryId().getId(), true, true, false);
        try {
            ListenableFuture<ConfigTaskResult> future = task.execute(this.configTaskExecutor);
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            if (result.getStatusCode().getStatusCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new RuntimeException(new IoTDBException(String.format("Auto add table column failed: %s.%s, %s", database, tableName, inputColumnList), result.getStatusCode().getStatusCode()));
            }
            DataNodeSchemaLockManager.getInstance().takeReadLock(context, SchemaLockType.VALIDATE_VS_DELETION_TABLE);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.warn("Auto add table column failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<TsTableColumnSchema> parseInputColumnSchema(List<ColumnSchema> inputColumnList) {
        ArrayList<TsTableColumnSchema> columnSchemaList = new ArrayList<TsTableColumnSchema>(inputColumnList.size());
        block6: for (ColumnSchema inputColumn : inputColumnList) {
            switch (inputColumn.getColumnCategory()) {
                case TAG: {
                    if (!inputColumn.getType().equals(StringType.STRING)) {
                        throw new SemanticException("Tag column only support data type STRING.");
                    }
                    columnSchemaList.add((TsTableColumnSchema)new TagColumnSchema(inputColumn.getName(), TSDataType.STRING));
                    continue block6;
                }
                case ATTRIBUTE: {
                    if (!inputColumn.getType().equals(StringType.STRING)) {
                        throw new SemanticException("Attribute column only support data type STRING.");
                    }
                    columnSchemaList.add((TsTableColumnSchema)new AttributeColumnSchema(inputColumn.getName(), TSDataType.STRING));
                    continue block6;
                }
                case FIELD: {
                    TSDataType dataType = InternalTypeManager.getTSDataType(inputColumn.getType());
                    columnSchemaList.add((TsTableColumnSchema)new FieldColumnSchema(inputColumn.getName(), dataType, EncodingInferenceUtils.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor(dataType)));
                    continue block6;
                }
                case TIME: {
                    throw new SemanticException("Adding column for column category " + inputColumn.getColumnCategory() + " is not supported");
                }
            }
            throw new IllegalStateException("Unknown ColumnCategory for adding column: " + inputColumn.getColumnCategory());
        }
        return columnSchemaList;
    }

    private static class TableHeaderSchemaValidatorHolder {
        private static final TableHeaderSchemaValidator INSTANCE = new TableHeaderSchemaValidator();

        private TableHeaderSchemaValidatorHolder() {
        }
    }
}

