/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.faulttolerance.runtime.config;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import io.smallrye.faulttolerance.api.BeforeRetryHandler;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.RateLimitType;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Predicate;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;

@ConfigMapping(prefix="quarkus.fault-tolerance")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface SmallRyeFaultToleranceConfig {
    @ConfigDocDefault(value="true")
    public Optional<Boolean> enabled();

    @WithName(value="metrics.enabled")
    @ConfigDocDefault(value="true")
    public Optional<Boolean> metricsEnabled();

    @ConfigDocDefault(value="false")
    public Optional<Boolean> mpCompatibility();

    @WithParentName
    @ConfigDocMapKey(value="<identifier>")
    public Map<String, StrategiesConfig> strategies();

    public static interface StrategiesConfig {
        public Optional<ApplyGuardConfig> applyGuard();

        public Optional<AsynchronousConfig> asynchronous();

        public Optional<AsynchronousNonBlockingConfig> asynchronousNonBlocking();

        public Optional<BeforeRetryConfig> beforeRetry();

        public Optional<BulkheadConfig> bulkhead();

        public Optional<CircuitBreakerConfig> circuitBreaker();

        public Optional<CustomBackoffConfig> customBackoff();

        public Optional<ExponentialBackoffConfig> exponentialBackoff();

        public Optional<FallbackConfig> fallback();

        public Optional<FibonacciBackoffConfig> fibonacciBackoff();

        public Optional<RateLimitConfig> rateLimit();

        public Optional<RetryConfig> retry();

        public Optional<RetryWhenConfig> retryWhen();

        public Optional<TimeoutConfig> timeout();

        public static interface TimeoutConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            public Optional<ChronoUnit> unit();

            @ConfigDocDefault(value="1 second")
            public OptionalLong value();
        }

        public static interface RetryWhenConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            @ConfigDocDefault(value="AlwaysOnException")
            public Optional<Class<? extends Predicate<Throwable>>> exception();

            @ConfigDocDefault(value="NeverOnResult")
            public Optional<Class<? extends Predicate<Object>>> result();
        }

        public static interface RetryConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            @ConfigDocDefault(value="<empty set>")
            public Optional<Class<? extends Throwable>[]> abortOn();

            @ConfigDocDefault(value="0")
            public OptionalLong delay();

            public Optional<ChronoUnit> delayUnit();

            @ConfigDocDefault(value="200 millis")
            public OptionalLong jitter();

            public Optional<ChronoUnit> jitterUnit();

            @ConfigDocDefault(value="3 minutes")
            public OptionalLong maxDuration();

            public Optional<ChronoUnit> maxDurationUnit();

            @ConfigDocDefault(value="3")
            public OptionalInt maxRetries();

            @ConfigDocDefault(value="Exception (all exceptions)")
            public Optional<Class<? extends Throwable>[]> retryOn();
        }

        public static interface RateLimitConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            @ConfigDocDefault(value="0")
            public OptionalLong minSpacing();

            public Optional<ChronoUnit> minSpacingUnit();

            @ConfigDocDefault(value="fixed")
            public Optional<RateLimitType> type();

            @ConfigDocDefault(value="100")
            public OptionalInt value();

            @ConfigDocDefault(value="1 second")
            public OptionalLong window();

            public Optional<ChronoUnit> windowUnit();
        }

        public static interface FibonacciBackoffConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            @ConfigDocDefault(value="1 minute")
            public OptionalLong maxDelay();

            public Optional<ChronoUnit> maxDelayUnit();
        }

        public static interface FallbackConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            @ConfigDocDefault(value="Throwable (all exceptions)")
            public Optional<Class<? extends Throwable>[]> applyOn();

            @ConfigDocDefault(value="<empty set>")
            public Optional<Class<? extends Throwable>[]> skipOn();

            public Optional<Class<? extends FallbackHandler<?>>> value();
        }

        public static interface ExponentialBackoffConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            @ConfigDocDefault(value="2")
            public OptionalInt factor();

            @ConfigDocDefault(value="1 minute")
            public OptionalLong maxDelay();

            public Optional<ChronoUnit> maxDelayUnit();
        }

        public static interface CustomBackoffConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            public Optional<Class<? extends CustomBackoffStrategy>> value();
        }

        public static interface CircuitBreakerConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            @ConfigDocDefault(value="5 seconds")
            public OptionalLong delay();

            public Optional<ChronoUnit> delayUnit();

            @ConfigDocDefault(value="Throwable (all exceptions)")
            public Optional<Class<? extends Throwable>[]> failOn();

            @ConfigDocDefault(value="0.5")
            public OptionalDouble failureRatio();

            @ConfigDocDefault(value="20")
            public OptionalInt requestVolumeThreshold();

            @ConfigDocDefault(value="<empty set>")
            public Optional<Class<? extends Throwable>[]> skipOn();

            @ConfigDocDefault(value="1")
            public OptionalInt successThreshold();
        }

        public static interface BulkheadConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            @ConfigDocDefault(value="10")
            public OptionalInt value();

            @ConfigDocDefault(value="10")
            public OptionalInt waitingTaskQueue();
        }

        public static interface BeforeRetryConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            public Optional<Class<? extends BeforeRetryHandler>> value();
        }

        public static interface AsynchronousNonBlockingConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();
        }

        public static interface AsynchronousConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();
        }

        public static interface ApplyGuardConfig {
            @ConfigDocDefault(value="true")
            public Optional<Boolean> enabled();

            public Optional<String> value();
        }
    }
}

