/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.cache;

import java.util.Objects;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityType;

public class EntityCacheByNameKey {
    private final long catalogId;
    private final long parentId;
    private final int typeCode;
    private final String name;

    public EntityCacheByNameKey(PolarisEntityType type, String name) {
        this.catalogId = PolarisEntityConstants.getNullId();
        this.parentId = PolarisEntityConstants.getRootEntityId();
        this.typeCode = type.getCode();
        this.name = name;
    }

    public EntityCacheByNameKey(long catalogId, long parentId, PolarisEntityType type, String name) {
        this.catalogId = catalogId;
        this.parentId = parentId;
        this.typeCode = type.getCode();
        this.name = name;
    }

    public EntityCacheByNameKey(PolarisBaseEntity baseEntity) {
        this.catalogId = baseEntity.getCatalogId();
        this.parentId = baseEntity.getParentId();
        this.typeCode = baseEntity.getTypeCode();
        this.name = baseEntity.getName();
    }

    public long getCatalogId() {
        return this.catalogId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public PolarisEntityType getType() {
        return PolarisEntityType.fromCode(this.typeCode);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityCacheByNameKey that = (EntityCacheByNameKey)o;
        return this.parentId == that.parentId && this.typeCode == that.typeCode && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.parentId, this.typeCode, this.name);
    }
}

