/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsFluentImpl;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArray;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArrayFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class JSONSchemaPropsOrArrayFluentImpl<A extends JSONSchemaPropsOrArrayFluent<A>>
extends BaseFluent<A>
implements JSONSchemaPropsOrArrayFluent<A> {
    private List<JSONSchemaPropsBuilder> jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();
    private JSONSchemaPropsBuilder schema;

    public JSONSchemaPropsOrArrayFluentImpl() {
    }

    public JSONSchemaPropsOrArrayFluentImpl(JSONSchemaPropsOrArray instance) {
        this.withJSONSchemas(instance.getJSONSchemas());
        this.withSchema(instance.getSchema());
    }

    @Override
    public A addToJSONSchemas(int index, JSONSchemaProps item) {
        if (this.jSONSchemas == null) {
            this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();
        }
        JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
        this._visitables.get((Object)"jSONSchemas").add(index >= 0 ? index : this._visitables.get((Object)"jSONSchemas").size(), builder);
        this.jSONSchemas.add(index >= 0 ? index : this.jSONSchemas.size(), builder);
        return (A)this;
    }

    @Override
    public A setToJSONSchemas(int index, JSONSchemaProps item) {
        if (this.jSONSchemas == null) {
            this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();
        }
        JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"jSONSchemas").size()) {
            this._visitables.get((Object)"jSONSchemas").add(builder);
        } else {
            this._visitables.get((Object)"jSONSchemas").set(index, builder);
        }
        if (index < 0 || index >= this.jSONSchemas.size()) {
            this.jSONSchemas.add(builder);
        } else {
            this.jSONSchemas.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToJSONSchemas(JSONSchemaProps ... items) {
        if (this.jSONSchemas == null) {
            this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();
        }
        for (JSONSchemaProps item : items) {
            JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
            this._visitables.get((Object)"jSONSchemas").add(builder);
            this.jSONSchemas.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToJSONSchemas(Collection<JSONSchemaProps> items) {
        if (this.jSONSchemas == null) {
            this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();
        }
        for (JSONSchemaProps item : items) {
            JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
            this._visitables.get((Object)"jSONSchemas").add(builder);
            this.jSONSchemas.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromJSONSchemas(JSONSchemaProps ... items) {
        for (JSONSchemaProps item : items) {
            JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
            this._visitables.get((Object)"jSONSchemas").remove(builder);
            if (this.jSONSchemas == null) continue;
            this.jSONSchemas.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJSONSchemas(Collection<JSONSchemaProps> items) {
        for (JSONSchemaProps item : items) {
            JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
            this._visitables.get((Object)"jSONSchemas").remove(builder);
            if (this.jSONSchemas == null) continue;
            this.jSONSchemas.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromJSONSchemas(Predicate<JSONSchemaPropsBuilder> predicate) {
        if (this.jSONSchemas == null) {
            return (A)this;
        }
        Iterator<JSONSchemaPropsBuilder> each = this.jSONSchemas.iterator();
        List visitables = this._visitables.get((Object)"jSONSchemas");
        while (each.hasNext()) {
            JSONSchemaPropsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<JSONSchemaProps> getJSONSchemas() {
        return JSONSchemaPropsOrArrayFluentImpl.build(this.jSONSchemas);
    }

    @Override
    public List<JSONSchemaProps> buildJSONSchemas() {
        return JSONSchemaPropsOrArrayFluentImpl.build(this.jSONSchemas);
    }

    @Override
    public JSONSchemaProps buildJSONSchema(int index) {
        return this.jSONSchemas.get(index).build();
    }

    @Override
    public JSONSchemaProps buildFirstJSONSchema() {
        return this.jSONSchemas.get(0).build();
    }

    @Override
    public JSONSchemaProps buildLastJSONSchema() {
        return this.jSONSchemas.get(this.jSONSchemas.size() - 1).build();
    }

    @Override
    public JSONSchemaProps buildMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
        for (JSONSchemaPropsBuilder item : this.jSONSchemas) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
        for (JSONSchemaPropsBuilder item : this.jSONSchemas) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withJSONSchemas(List<JSONSchemaProps> jSONSchemas) {
        if (this.jSONSchemas != null) {
            this._visitables.get((Object)"jSONSchemas").removeAll(this.jSONSchemas);
        }
        if (jSONSchemas != null) {
            this.jSONSchemas = new ArrayList<JSONSchemaPropsBuilder>();
            for (JSONSchemaProps item : jSONSchemas) {
                this.addToJSONSchemas(item);
            }
        } else {
            this.jSONSchemas = null;
        }
        return (A)this;
    }

    @Override
    public A withJSONSchemas(JSONSchemaProps ... jSONSchemas) {
        if (this.jSONSchemas != null) {
            this.jSONSchemas.clear();
        }
        if (jSONSchemas != null) {
            for (JSONSchemaProps item : jSONSchemas) {
                this.addToJSONSchemas(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasJSONSchemas() {
        return this.jSONSchemas != null && !this.jSONSchemas.isEmpty();
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.JSONSchemasNested<A> addNewJSONSchema() {
        return new JSONSchemasNestedImpl();
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.JSONSchemasNested<A> addNewJSONSchemaLike(JSONSchemaProps item) {
        return new JSONSchemasNestedImpl(-1, item);
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.JSONSchemasNested<A> setNewJSONSchemaLike(int index, JSONSchemaProps item) {
        return new JSONSchemasNestedImpl(index, item);
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.JSONSchemasNested<A> editJSONSchema(int index) {
        if (this.jSONSchemas.size() <= index) {
            throw new RuntimeException("Can't edit jSONSchemas. Index exceeds size.");
        }
        return this.setNewJSONSchemaLike(index, this.buildJSONSchema(index));
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.JSONSchemasNested<A> editFirstJSONSchema() {
        if (this.jSONSchemas.size() == 0) {
            throw new RuntimeException("Can't edit first jSONSchemas. The list is empty.");
        }
        return this.setNewJSONSchemaLike(0, this.buildJSONSchema(0));
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.JSONSchemasNested<A> editLastJSONSchema() {
        int index = this.jSONSchemas.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last jSONSchemas. The list is empty.");
        }
        return this.setNewJSONSchemaLike(index, this.buildJSONSchema(index));
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.JSONSchemasNested<A> editMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.jSONSchemas.size(); ++i) {
            if (!predicate.test(this.jSONSchemas.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching jSONSchemas. No match found.");
        }
        return this.setNewJSONSchemaLike(index, this.buildJSONSchema(index));
    }

    @Override
    @Deprecated
    public JSONSchemaProps getSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    @Override
    public JSONSchemaProps buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    @Override
    public A withSchema(JSONSchemaProps schema) {
        this._visitables.get((Object)"schema").remove(this.schema);
        if (schema != null) {
            this.schema = new JSONSchemaPropsBuilder(schema);
            this._visitables.get((Object)"schema").add(this.schema);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSchema() {
        return this.schema != null;
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.SchemaNested<A> withNewSchema() {
        return new SchemaNestedImpl();
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.SchemaNested<A> withNewSchemaLike(JSONSchemaProps item) {
        return new SchemaNestedImpl(item);
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.SchemaNested<A> editSchema() {
        return this.withNewSchemaLike(this.getSchema());
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(this.getSchema() != null ? this.getSchema() : new JSONSchemaPropsBuilder().build());
    }

    @Override
    public JSONSchemaPropsOrArrayFluent.SchemaNested<A> editOrNewSchemaLike(JSONSchemaProps item) {
        return this.withNewSchemaLike(this.getSchema() != null ? this.getSchema() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONSchemaPropsOrArrayFluentImpl that = (JSONSchemaPropsOrArrayFluentImpl)o;
        if (this.jSONSchemas != null ? !this.jSONSchemas.equals(that.jSONSchemas) : that.jSONSchemas != null) {
            return false;
        }
        return !(this.schema != null ? !this.schema.equals(that.schema) : that.schema != null);
    }

    public int hashCode() {
        return Objects.hash(this.jSONSchemas, this.schema, super.hashCode());
    }

    public class SchemaNestedImpl<N>
    extends JSONSchemaPropsFluentImpl<JSONSchemaPropsOrArrayFluent.SchemaNested<N>>
    implements JSONSchemaPropsOrArrayFluent.SchemaNested<N>,
    Nested<N> {
        private final JSONSchemaPropsBuilder builder;

        SchemaNestedImpl(JSONSchemaProps item) {
            this.builder = new JSONSchemaPropsBuilder(this, item);
        }

        SchemaNestedImpl() {
            this.builder = new JSONSchemaPropsBuilder(this);
        }

        @Override
        public N and() {
            return (N)JSONSchemaPropsOrArrayFluentImpl.this.withSchema(this.builder.build());
        }

        @Override
        public N endSchema() {
            return this.and();
        }
    }

    public class JSONSchemasNestedImpl<N>
    extends JSONSchemaPropsFluentImpl<JSONSchemaPropsOrArrayFluent.JSONSchemasNested<N>>
    implements JSONSchemaPropsOrArrayFluent.JSONSchemasNested<N>,
    Nested<N> {
        private final JSONSchemaPropsBuilder builder;
        private final int index;

        JSONSchemasNestedImpl(int index, JSONSchemaProps item) {
            this.index = index;
            this.builder = new JSONSchemaPropsBuilder(this, item);
        }

        JSONSchemasNestedImpl() {
            this.index = -1;
            this.builder = new JSONSchemaPropsBuilder(this);
        }

        @Override
        public N and() {
            return (N)JSONSchemaPropsOrArrayFluentImpl.this.setToJSONSchemas(this.index, this.builder.build());
        }

        @Override
        public N endJSONSchema() {
            return this.and();
        }
    }
}

