/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basecrdt.core.api.CRDTURI;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDT;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.service.CRDTCluster;
import org.apache.bifromq.basecrdt.service.CRDTServiceOptions;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.basecrdt.store.CRDTStoreOptions;
import org.apache.bifromq.basecrdt.store.ICRDTStore;
import org.apache.bifromq.basecrdt.store.proto.CRDTStoreMessage;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

public class CRDTService
implements ICRDTService {
    private final Logger log;
    private final ICRDTStore store;
    private final IAgentHost agentHost;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final Map<String, CRDTCluster<?, ?>> hostedCRDT = Maps.newConcurrentMap();
    private final Subject<CRDTStoreMessage> incomingStoreMessages;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(EnvProvider.INSTANCE.newThreadFactory("crdt-service-scheduler"));
    private final Scheduler scheduler = Schedulers.from((Executor)this.executor);

    public CRDTService(IAgentHost agentHost, CRDTServiceOptions options) {
        this.log = MDCLogger.getLogger(CRDTService.class, (String[])new String[]{"store", options.storeOptions.id()});
        this.agentHost = agentHost;
        this.store = ICRDTStore.newInstance((CRDTStoreOptions)options.storeOptions);
        this.incomingStoreMessages = PublishSubject.create().toSerialized();
        this.start();
    }

    @Override
    public String id() {
        return this.store.id();
    }

    @Override
    public ByteString agentHostId() {
        this.checkState();
        return this.agentHost.local().getId();
    }

    @Override
    public <O extends ICRDTOperation, C extends ICausalCRDT<O>> C host(String uri) {
        this.checkState();
        CRDTCluster crdtContext = this.hostedCRDT.computeIfAbsent(uri, k -> new CRDTCluster((String)k, this.store, this.agentHost, this.scheduler, this.incomingStoreMessages));
        return crdtContext.crdt();
    }

    @Override
    public CompletableFuture<Void> stopHosting(String uri) {
        this.checkState();
        assert (this.hostedCRDT.containsKey(uri));
        return this.stopHostingInternal(uri);
    }

    @Override
    public Observable<Set<Replica>> aliveReplicas(String uri) {
        this.checkState();
        assert (this.hostedCRDT.containsKey(uri));
        return this.hostedCRDT.get(uri).aliveReplicas();
    }

    @Override
    public Observable<Set<String>> aliveCRDTs() {
        return this.agentHost.landscape().map(agentLandscape -> {
            HashSet<String> crdtUris = new HashSet<String>();
            for (Map.Entry entry : agentLandscape.entrySet()) {
                for (String agentId : (Set)entry.getValue()) {
                    if (!CRDTURI.isValidURI((String)agentId)) continue;
                    crdtUris.add(agentId);
                }
            }
            return crdtUris;
        });
    }

    @Override
    public Observable<Long> refreshSignal() {
        return this.agentHost.refuteSignal();
    }

    private CompletableFuture<Void> stopHostingInternal(String uri) {
        return this.hostedCRDT.remove(uri).close();
    }

    private void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            this.store.start(this.incomingStoreMessages);
            this.state.set(State.STARTED);
            this.log.debug("CRDT service[{}] started", (Object)this.store.id());
        }
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            this.log.debug("Stopping CRDT service[{}]", (Object)this.id());
            this.log.debug("Stop hosting CRDTs");
            CompletableFuture.allOf((CompletableFuture[])this.hostedCRDT.values().stream().map(CRDTCluster::close).toArray(CompletableFuture[]::new)).join();
            this.log.debug("Stopping CRDT store");
            this.store.stop();
            this.log.debug("CRDT service[{}] stopped", (Object)this.id());
            this.executor.shutdown();
            this.state.set(State.SHUTDOWN);
        }
    }

    private void checkState() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"Not started");
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        STOPPING,
        SHUTDOWN;

    }
}

