/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageConstraintException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParser;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.io.TimeoutByteArrayInputStream;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestResponseParser {
    TestResponseParser() {
    }

    @Test
    void testBasicMessageParsing() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nServer: whatever\r\nDate: some date\r\nSet-Cookie: c1=stuff\r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nServer: whatever\r\nDate: some date\r\nSet-Cookie: c1=stuff\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser();
        ClassicHttpResponse httpresponse = (ClassicHttpResponse)parser.parse((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        Assertions.assertEquals((int)200, (int)httpresponse.getCode());
        Assertions.assertEquals((Object)"OK", (Object)httpresponse.getReasonPhrase());
        Header[] headers = httpresponse.getHeaders();
        Assertions.assertEquals((int)3, (int)headers.length);
    }

    @Test
    void testConnectionClosedException() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser();
        ClassicHttpResponse response = (ClassicHttpResponse)parser.parse((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        Assertions.assertNull((Object)response);
    }

    @Test
    void testBasicMessageParsingLeadingEmptyLines() throws Exception {
        String s = "\r\n\r\nHTTP/1.1 200 OK\r\nServer: whatever\r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("\r\n\r\nHTTP/1.1 200 OK\r\nServer: whatever\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser(Http1Config.custom().setMaxEmptyLineCount(3).build());
        ClassicHttpResponse httpresponse = (ClassicHttpResponse)parser.parse((SessionInputBuffer)inBuffer, (InputStream)inputStream);
        Assertions.assertEquals((int)200, (int)httpresponse.getCode());
        Assertions.assertEquals((Object)"OK", (Object)httpresponse.getReasonPhrase());
        Header[] headers = httpresponse.getHeaders();
        Assertions.assertEquals((int)1, (int)headers.length);
    }

    @Test
    void testBasicMessageParsingTooManyLeadingEmptyLines() {
        String s = "\r\n\r\n\r\nHTTP/1.1 200 OK\r\nServer: whatever\r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("\r\n\r\n\r\nHTTP/1.1 200 OK\r\nServer: whatever\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser(Http1Config.custom().setMaxEmptyLineCount(3).build());
        Assertions.assertThrows(MessageConstraintException.class, () -> TestResponseParser.lambda$testBasicMessageParsingTooManyLeadingEmptyLines$0(parser, (SessionInputBuffer)inBuffer, inputStream));
    }

    @Test
    void testMessageParsingTimeout() throws Exception {
        String s = "HTTP\u0000/1.1 200\u0000 OK\r\nServer: wha\u0000tever\r\nDate: some date\r\nSet-Coo\u0000kie: c1=stuff\r\n\u0000\r\n";
        TimeoutByteArrayInputStream inputStream = new TimeoutByteArrayInputStream("HTTP\u0000/1.1 200\u0000 OK\r\nServer: wha\u0000tever\r\nDate: some date\r\nSet-Coo\u0000kie: c1=stuff\r\n\u0000\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        DefaultHttpResponseParser parser = new DefaultHttpResponseParser();
        int timeoutCount = 0;
        ClassicHttpResponse httpresponse = null;
        for (int i = 0; i < 10; ++i) {
            try {
                httpresponse = (ClassicHttpResponse)parser.parse((SessionInputBuffer)inBuffer, (InputStream)inputStream);
                break;
            }
            catch (InterruptedIOException ex) {
                ++timeoutCount;
                continue;
            }
        }
        Assertions.assertNotNull(httpresponse);
        Assertions.assertEquals((int)5, (int)timeoutCount);
        Assertions.assertEquals((int)200, (int)httpresponse.getCode());
        Assertions.assertEquals((Object)"OK", (Object)httpresponse.getReasonPhrase());
        Header[] headers = httpresponse.getHeaders();
        Assertions.assertEquals((int)3, (int)headers.length);
    }

    private static /* synthetic */ void lambda$testBasicMessageParsingTooManyLeadingEmptyLines$0(DefaultHttpResponseParser parser, SessionInputBuffer inBuffer, ByteArrayInputStream inputStream) throws Throwable {
        ClassicHttpResponse cfr_ignored_0 = (ClassicHttpResponse)parser.parse(inBuffer, (InputStream)inputStream);
    }
}

