/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.ssl;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.core.SocketFactoryFactory;
import com.amazon.redshift.jdbc.SslMode;
import com.amazon.redshift.ssl.LibPQFactory;
import com.amazon.redshift.ssl.RedshiftjdbcHostnameVerifier;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.ObjectFactory;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.io.IOException;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL
extends ObjectFactory {
    public static void convert(RedshiftStream stream, Properties info) throws RedshiftException, IOException {
        SslMode sslMode;
        SSLSocket newConnection;
        SSLSocketFactory factory = SocketFactoryFactory.getSslSocketFactory(info);
        try {
            newConnection = (SSLSocket)factory.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            newConnection.setUseClientMode(true);
            newConnection.startHandshake();
        }
        catch (IOException ex) {
            throw new RedshiftException(GT.tr("SSL error: {0}", ex.getMessage()), RedshiftState.CONNECTION_FAILURE, (Throwable)ex);
        }
        if (factory instanceof LibPQFactory) {
            ((LibPQFactory)factory).throwKeyManagerException();
        }
        if ((sslMode = SslMode.of(info)).verifyPeerName()) {
            MakeSSL.verifyPeerName(stream, info, newConnection);
        }
        stream.changeSocket(newConnection, false, info);
    }

    private static void verifyPeerName(RedshiftStream stream, Properties info, SSLSocket newConnection) throws RedshiftException {
        HostnameVerifier hvn;
        String sslhostnameverifier = RedshiftProperty.SSL_HOSTNAME_VERIFIER.get(info);
        if (sslhostnameverifier == null) {
            hvn = RedshiftjdbcHostnameVerifier.INSTANCE;
            sslhostnameverifier = "RedshiftjdbcHostnameVerifier";
        } else {
            try {
                hvn = MakeSSL.instantiate(HostnameVerifier.class, sslhostnameverifier, info, false, null);
            }
            catch (Exception e) {
                throw new RedshiftException(GT.tr("The HostnameVerifier class provided {0} could not be instantiated.", sslhostnameverifier), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        if (hvn.verify(stream.getHostSpec().getHost(), newConnection.getSession())) {
            return;
        }
        throw new RedshiftException(GT.tr("The hostname {0} could not be verified by hostnameverifier {1}.", stream.getHostSpec().getHost(), sslhostnameverifier), RedshiftState.CONNECTION_FAILURE);
    }
}

