/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.streamlookup;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.streamlookup.StreamLookup;
import org.apache.hop.pipeline.transforms.streamlookup.StreamLookupData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="StreamLookupMeta.Injection.")
@Transform(id="StreamLookup", image="streamlookup.svg", name="i18n::StreamLookup.Name", description="i18n::StreamLookup.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::StreamLookupMeta.keyword"}, documentationUrl="/pipeline/transforms/streamlookup.html")
public class StreamLookupMeta
extends BaseTransformMeta<StreamLookup, StreamLookupData> {
    private static final Class<?> PKG = StreamLookupMeta.class;
    public static final String CONST_SPACES = "        ";
    @Injection(name="KEY_STREAM")
    private String[] keystream;
    @Injection(name="KEY_LOOKUP")
    private String[] keylookup;
    @Injection(name="RETRIEVE_VALUE")
    private String[] value;
    @Injection(name="RETRIEVE_VALUE_NAME")
    private String[] valueName;
    @Injection(name="RETRIEVE_VALUE_DEFAULT")
    private String[] valueDefault;
    @Injection(name="RETRIEVE_DEFAULT_TYPE")
    private int[] valueDefaultType;
    private boolean inputSorted;
    @Injection(name="PRESERVE_MEMORY")
    private boolean memoryPreservationActive;
    @Injection(name="SORTED_LIST")
    private boolean usingSortedList;
    @Injection(name="INTEGER_PAIR")
    private boolean usingIntegerPair;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.setKeystream(new String[nrkeys]);
        this.setKeylookup(new String[nrkeys]);
        this.setValue(new String[nrvalues]);
        this.setValueName(new String[nrvalues]);
        this.setValueDefault(new String[nrvalues]);
        this.setValueDefaultType(new int[nrvalues]);
    }

    public Object clone() {
        StreamLookupMeta retval = (StreamLookupMeta)((Object)super.clone());
        ITransformIOMeta thisTransformIO = this.getTransformIOMeta();
        ITransformIOMeta thatTransformIO = retval.getTransformIOMeta();
        if (thisTransformIO != null && thisTransformIO.getInfoStreams() != null && thatTransformIO != null && thatTransformIO.getInfoStreams() != null) {
            List thisInfoStream = thisTransformIO.getInfoStreams();
            List thatInfoStream = thatTransformIO.getInfoStreams();
            ((IStream)thatInfoStream.get(0)).setStreamType(((IStream)thisInfoStream.get(0)).getStreamType());
            ((IStream)thatInfoStream.get(0)).setTransformMeta(((IStream)thisInfoStream.get(0)).getTransformMeta());
            ((IStream)thatInfoStream.get(0)).setDescription(((IStream)thisInfoStream.get(0)).getDescription());
            ((IStream)thatInfoStream.get(0)).setStreamIcon(((IStream)thisInfoStream.get(0)).getStreamIcon());
            ((IStream)thatInfoStream.get(0)).setSubject(((IStream)thisInfoStream.get(0)).getSubject());
        }
        int nrkeys = this.keystream.length;
        int nrvals = this.value.length;
        retval.allocate(nrkeys, nrvals);
        System.arraycopy(this.keystream, 0, retval.keystream, 0, nrkeys);
        System.arraycopy(this.keylookup, 0, retval.keylookup, 0, nrkeys);
        System.arraycopy(this.value, 0, retval.value, 0, nrvals);
        System.arraycopy(this.valueName, 0, retval.valueName, 0, nrvals);
        System.arraycopy(this.valueDefault, 0, retval.valueDefault, 0, nrvals);
        System.arraycopy(this.valueDefaultType, 0, retval.valueDefaultType, 0, nrvals);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            int i;
            String lookupFromTransformName = XmlHandler.getTagValue((Node)transformNode, (String)"from");
            IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromTransformName);
            this.setInputSorted("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"input_sorted")));
            this.setMemoryPreservationActive("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"preserve_memory")));
            this.setUsingSortedList("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"sorted_list")));
            this.setUsingIntegerPair("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"integer_pair")));
            Node lookup = XmlHandler.getSubNode((Node)transformNode, (String)"lookup");
            int nrkeys = XmlHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XmlHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.getKeystream()[i] = XmlHandler.getTagValue((Node)knode, (String)"name");
                this.getKeylookup()[i] = XmlHandler.getTagValue((Node)knode, (String)"field");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.getValue()[i] = XmlHandler.getTagValue((Node)vnode, (String)"name");
                this.getValueName()[i] = XmlHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.getValueName()[i] == null) {
                    this.getValueName()[i] = this.getValue()[i];
                }
                this.getValueDefault()[i] = XmlHandler.getTagValue((Node)vnode, (String)"default");
                String dtype = XmlHandler.getTagValue((Node)vnode, (String)"type");
                this.getValueDefaultType()[i] = ValueMetaFactory.getIdForValueMeta((String)dtype);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public void setDefault() {
        this.setMemoryPreservationActive(true);
        this.setUsingSortedList(false);
        this.setUsingIntegerPair(false);
        this.allocate(0, 0);
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (info != null && info.length == 1 && info[0] != null) {
            for (int i = 0; i < this.getValueName().length; ++i) {
                IValueMeta valueMeta = info[0].searchValueMeta(this.getValue()[i]);
                if (valueMeta == null) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.ReturnValueCanNotBeFound", (String[])new String[]{this.getValue()[i]}));
                }
                valueMeta.setName(this.getValueName()[i]);
                valueMeta.setOrigin(origin);
                row.addValueMeta(valueMeta);
            }
        } else {
            for (int i = 0; i < this.getValueName().length; ++i) {
                try {
                    IValueMeta v = ValueMetaFactory.createValueMeta((String)this.getValueName()[i], (int)this.getValueDefaultType()[i]);
                    v.setOrigin(origin);
                    row.addValueMeta(v);
                    continue;
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
        }
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder();
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        retval.append("    ").append(XmlHandler.addTagValue((String)"from", (String)infoStream.getTransformName()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"input_sorted", (boolean)this.isInputSorted()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"preserve_memory", (boolean)this.isMemoryPreservationActive()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sorted_list", (boolean)this.isUsingSortedList()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"integer_pair", (boolean)this.isUsingIntegerPair()));
        retval.append("    <lookup>").append(Const.CR);
        for (i = 0; i < this.getKeystream().length; ++i) {
            retval.append("      <key>").append(Const.CR);
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.getKeystream()[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"field", (String)this.getKeylookup()[i]));
            retval.append("      </key>").append(Const.CR);
        }
        for (i = 0; i < this.getValue().length; ++i) {
            retval.append("      <value>").append(Const.CR);
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.getValue()[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"rename", (String)this.getValueName()[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"default", (String)this.getValueDefault()[i]));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.getValueDefaultType()[i])));
            retval.append("      </value>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int idx;
        boolean errorFound;
        Object errorMessage;
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            errorMessage = "";
            errorFound = false;
            for (String aKeystream : this.getKeystream()) {
                idx = prev.indexOfValue(aKeystream);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + aKeystream + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.CouldNotFindFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (info != null && !info.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.TransformReceivingLookupData", (String[])new String[]{"" + info.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            errorMessage = "";
            errorFound = false;
            for (String aKeylookup : this.getKeylookup()) {
                idx = info.indexOfValue(aKeylookup);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + aKeylookup + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundInLookupStream", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFoundInTheLookupStream", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            for (String aValue : this.getValue()) {
                idx = info.indexOfValue(aValue);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + aValue + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundInLookupStream2", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFoundInTheLookupStream2", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundFromInLookupSep", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        if (infoStream.getTransformMeta() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceTransformNotSelected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceTransformIsSelected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            if (info != null) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceTransformExist", (String[])new String[]{infoStream.getTransformName()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceTransformDoesNotExist", (String[])new String[]{infoStream.getTransformName()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length >= 2) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.TransformReceivingInfoFromInputTransforms", (String[])new String[]{"" + input.length}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.NeedAtLeast2InputStreams", (String[])new String[]{Const.CR, Const.CR}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"StreamLookupMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            ioMeta.addStream((IStream)stream);
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void resetTransformIoMeta() {
    }

    public boolean isInputSorted() {
        return this.inputSorted;
    }

    public void setInputSorted(boolean inputSorted) {
        this.inputSorted = inputSorted;
    }

    public String[] getKeylookup() {
        return this.keylookup;
    }

    public void setKeylookup(String[] keylookup) {
        this.keylookup = keylookup;
    }

    public String[] getKeystream() {
        return this.keystream;
    }

    public void setKeystream(String[] keystream) {
        this.keystream = keystream;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public String[] getValueDefault() {
        return this.valueDefault;
    }

    public void setValueDefault(String[] valueDefault) {
        this.valueDefault = valueDefault;
    }

    public int[] getValueDefaultType() {
        return this.valueDefaultType;
    }

    public void setValueDefaultType(int[] valueDefaultType) {
        this.valueDefaultType = valueDefaultType;
    }

    public String[] getValueName() {
        return this.valueName;
    }

    public void setValueName(String[] valueName) {
        this.valueName = valueName;
    }

    public boolean isMemoryPreservationActive() {
        return this.memoryPreservationActive;
    }

    public void setMemoryPreservationActive(boolean memoryPreservationActive) {
        this.memoryPreservationActive = memoryPreservationActive;
    }

    public boolean isUsingSortedList() {
        return this.usingSortedList;
    }

    public void setUsingSortedList(boolean usingSortedList) {
        this.usingSortedList = usingSortedList;
    }

    public boolean isUsingIntegerPair() {
        return this.usingIntegerPair;
    }

    public void setUsingIntegerPair(boolean usingIntegerPair) {
        this.usingIntegerPair = usingIntegerPair;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        if (this.value == null || this.value.length == 0) {
            return;
        }
        int nrFields = this.value.length;
        if (this.valueDefaultType.length < nrFields) {
            int[] newValueDefaultType = new int[nrFields];
            System.arraycopy(this.valueDefaultType, 0, newValueDefaultType, 0, this.valueDefaultType.length);
            for (int i = this.valueDefaultType.length; i < newValueDefaultType.length; ++i) {
                newValueDefaultType[i] = -1;
            }
            this.valueDefaultType = newValueDefaultType;
        }
        if (this.valueName.length < nrFields) {
            String[] newValueName = new String[nrFields];
            System.arraycopy(this.valueName, 0, newValueName, 0, this.valueName.length);
            this.valueName = newValueName;
        }
        if (this.valueDefault.length < nrFields) {
            String[] newValueDefault = new String[nrFields];
            System.arraycopy(this.valueDefault, 0, newValueDefault, 0, this.valueDefault.length);
            this.valueDefault = newValueDefault;
        }
    }
}

