/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectLongPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectLongProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ImmutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.ObjectLongPair;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectLongMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableObjectLongEmptyMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableObjectLongSingletonMap<K>
extends AbstractImmutableObjectLongMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_VALUE = 0L;
    private final K key1;
    private final long value1;

    ImmutableObjectLongSingletonMap(K key1, long value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public LongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)ObjectLongHashMap.newWithKeysValues(this.key1, this.value1).longIterator());
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(LongPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableLongCollection select(LongPredicate predicate) {
        return predicate.accept(this.value1) ? LongLists.immutable.with(this.value1) : LongLists.immutable.with();
    }

    public ImmutableLongCollection reject(LongPredicate predicate) {
        return predicate.accept(this.value1) ? LongLists.immutable.with() : LongLists.immutable.with(this.value1);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)LongLists.immutable.with(this.value1));
    }

    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public long sum() {
        return this.value1;
    }

    public long min() {
        return this.value1;
    }

    public long max() {
        return this.value1;
    }

    public long maxIfEmpty(long defaultValue) {
        return this.value1;
    }

    public long minIfEmpty(long defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public long[] toSortedArray() {
        return new long[]{this.value1};
    }

    public MutableLongList toSortedList() {
        return LongArrayList.newListWith(this.value1);
    }

    public long[] toArray() {
        return new long[]{this.value1};
    }

    public long[] toArray(long[] target) {
        if (target.length < 1) {
            target = new long[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(long value) {
        return this.value1 == value;
    }

    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableLongList toList() {
        return LongArrayList.newListWith(this.value1);
    }

    public MutableLongSet toSet() {
        return LongHashSet.newSetWith(this.value1);
    }

    public MutableLongBag toBag() {
        return LongHashBag.newBagWith(this.value1);
    }

    public LazyLongIterable asLazy() {
        return new LazyLongIterableAdapter((LongIterable)this);
    }

    public ImmutableObjectLongMap<K> newWithKeyValue(K key, long value) {
        return ObjectLongMaps.immutable.withAll(ObjectLongHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableObjectLongMap<K> newWithoutKey(K key) {
        return ImmutableObjectLongSingletonMap.nullSafeEquals(this.key1, key) ? ImmutableObjectLongEmptyMap.INSTANCE : this;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public ImmutableObjectLongMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectLongHashMap<K> map = new ObjectLongHashMap<K>(this);
        for (K key : keys) {
            map.removeKey(key);
        }
        return map.toImmutable();
    }

    public long get(Object key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getOrThrow(Object key) {
        if (ImmutableObjectLongSingletonMap.nullSafeEquals(this.key1, key)) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public long getIfAbsent(Object key, long ifAbsent) {
        return ImmutableObjectLongSingletonMap.nullSafeEquals(this.key1, key) ? this.value1 : ifAbsent;
    }

    public boolean containsKey(Object key) {
        return ImmutableObjectLongSingletonMap.nullSafeEquals(this.key1, key);
    }

    public boolean containsValue(long value) {
        return this.value1 == value;
    }

    public void forEachValue(LongProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ObjectLongProcedure<? super K> objectLongProcedure) {
        objectLongProcedure.value(this.key1, this.value1);
    }

    public ImmutableObjectLongMap<K> select(ObjectLongPredicate<? super K> objectLongPredicate) {
        return objectLongPredicate.accept(this.key1, this.value1) ? ObjectLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : ImmutableObjectLongEmptyMap.INSTANCE;
    }

    public ImmutableObjectLongMap<K> reject(ObjectLongPredicate<? super K> objectLongPredicate) {
        return objectLongPredicate.accept(this.key1, this.value1) ? ImmutableObjectLongEmptyMap.INSTANCE : ObjectLongHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableObjectLongMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public Set<K> keySet() {
        return Sets.immutable.of(this.key1).castToSet();
    }

    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of((MutableLongCollection)LongArrayList.newListWith(this.value1));
    }

    public LazyIterable<K> keysView() {
        return Lists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ObjectLongPair<K>> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableLongObjectMap<K> flipUniqueValues() {
        return LongObjectMaps.immutable.with(this.value1, this.key1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectLongMap)) {
            return false;
        }
        ObjectLongMap map = (ObjectLongMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (this.key1 == null ? 0 : this.key1.hashCode()) ^ (int)(this.value1 ^ this.value1 >>> 32);
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectLongMap.ImmutableObjectLongMapSerializationProxy(this);
    }
}

