/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.plugins;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hop.core.plugins.HopURLClassLoader;

public class HopSelectiveParentFirstClassLoader
extends HopURLClassLoader {
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public HopSelectiveParentFirstClassLoader(URL[] url, ClassLoader classLoader, String[] patterns) {
        super(url, classLoader);
        this.addPatterns(patterns);
    }

    public HopSelectiveParentFirstClassLoader(URL[] url, ClassLoader classLoader, String name, String[] patterns) {
        super(url, classLoader, name);
        this.addPatterns(patterns);
    }

    public void addPatterns(String[] patterns) {
        if (patterns != null) {
            this.patterns.addAll(Arrays.stream(patterns).map(Pattern::compile).collect(Collectors.toList()));
        }
    }

    private Class<?> loadClassParentFirst(String arg0, boolean arg1) throws ClassNotFoundException {
        try {
            return this.loadClassFromParent(arg0, arg1);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return this.loadClassFromThisLoader(arg0, arg1);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return this.loadClassParentFirst(name, resolve);
        }
        return super.loadClass(name, resolve);
    }
}

