/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudstackSnitch
extends AbstractNetworkTopologySnitch {
    protected static final Logger logger = LoggerFactory.getLogger(CloudstackSnitch.class);
    protected static final String ZONE_NAME_QUERY_URI = "/latest/meta-data/availability-zone";
    private Map<InetAddressAndPort, Map<String, String>> savedEndpoints;
    private static final String DEFAULT_DC = "UNKNOWN-DC";
    private static final String DEFAULT_RACK = "UNKNOWN-RACK";
    private static final String[] LEASE_FILES = new String[]{"file:///var/lib/dhcp/dhclient.eth0.leases", "file:///var/lib/dhclient/dhclient.eth0.leases"};
    protected String csZoneDc;
    protected String csZoneRack;

    public CloudstackSnitch() throws IOException, ConfigurationException {
        String endpoint = this.csMetadataEndpoint();
        String zone = this.csQueryMetadata(endpoint + ZONE_NAME_QUERY_URI);
        String[] zone_parts = zone.split("-");
        if (zone_parts.length != 3) {
            throw new ConfigurationException("CloudstackSnitch cannot handle invalid zone format: " + zone);
        }
        this.csZoneDc = zone_parts[0] + "-" + zone_parts[1];
        this.csZoneRack = zone_parts[2];
    }

    @Override
    public String getRack(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.csZoneRack;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.RACK) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("rack");
            }
            return DEFAULT_RACK;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public String getDatacenter(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.csZoneDc;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.DC) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("data_center");
            }
            return DEFAULT_DC;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String csQueryMetadata(String url) throws ConfigurationException, IOException {
        String string;
        HttpURLConnection conn = null;
        DataInputStream is = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
        }
        catch (Exception e) {
            throw new ConfigurationException("CloudstackSnitch cannot query wrong metadata URL: " + url);
        }
        try {
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() != 200) {
                throw new ConfigurationException("CloudstackSnitch was unable to query metadata.");
            }
            int cl = conn.getContentLength();
            byte[] b = new byte[cl];
            is = new DataInputStream(new BufferedInputStream(conn.getInputStream()));
            is.readFully(b);
            string = new String(b, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            FileUtils.close(is);
            conn.disconnect();
            throw throwable;
        }
        FileUtils.close(is);
        conn.disconnect();
        return string;
    }

    String csMetadataEndpoint() throws ConfigurationException {
        for (String lease_uri : LEASE_FILES) {
            try {
                File lease_file = new File(new URI(lease_uri));
                if (!lease_file.exists()) continue;
                return this.csEndpointFromLease(lease_file);
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
            }
        }
        throw new ConfigurationException("No valid DHCP lease file could be found.");
    }

    String csEndpointFromLease(File lease) throws ConfigurationException {
        String endpoint = null;
        Pattern identifierPattern = Pattern.compile("^[ \t]*option dhcp-server-identifier (.*);$");
        try (BufferedReader reader = new BufferedReader(new FileReader(lease));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = identifierPattern.matcher(line);
                if (!matcher.find()) continue;
                endpoint = matcher.group(1);
                break;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("CloudstackSnitch cannot access lease file.");
        }
        if (endpoint == null) {
            throw new ConfigurationException("No metadata server could be found in lease file.");
        }
        return "http://" + endpoint;
    }
}

