/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.implcore.stats;

import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.opencensus.common.Clock;
import com.clickhouse.client.internal.opencensus.implcore.internal.CurrentState;
import com.clickhouse.client.internal.opencensus.implcore.internal.EventQueue;
import com.clickhouse.client.internal.opencensus.implcore.stats.MetricProducerImpl;
import com.clickhouse.client.internal.opencensus.implcore.stats.StatsManager;
import com.clickhouse.client.internal.opencensus.implcore.stats.StatsRecorderImpl;
import com.clickhouse.client.internal.opencensus.implcore.stats.ViewManagerImpl;
import com.clickhouse.client.internal.opencensus.metrics.Metrics;
import com.clickhouse.client.internal.opencensus.stats.StatsCollectionState;
import com.clickhouse.client.internal.opencensus.stats.StatsComponent;

public class StatsComponentImplBase
extends StatsComponent {
    private static final CurrentState.State DEFAULT_STATE = CurrentState.State.ENABLED;
    private final CurrentState currentState = new CurrentState(DEFAULT_STATE);
    private final ViewManagerImpl viewManager;
    private final StatsRecorderImpl statsRecorder;

    public StatsComponentImplBase(EventQueue queue, Clock clock) {
        StatsManager statsManager = new StatsManager(queue, clock, this.currentState);
        this.viewManager = new ViewManagerImpl(statsManager);
        this.statsRecorder = new StatsRecorderImpl(statsManager);
        MetricProducerImpl metricProducer = new MetricProducerImpl(statsManager);
        Metrics.getExportComponent().getMetricProducerManager().add(metricProducer);
    }

    @Override
    public ViewManagerImpl getViewManager() {
        return this.viewManager;
    }

    @Override
    public StatsRecorderImpl getStatsRecorder() {
        return this.statsRecorder;
    }

    @Override
    public StatsCollectionState getState() {
        return StatsComponentImplBase.stateToStatsState(this.currentState.get());
    }

    @Override
    public synchronized void setState(StatsCollectionState newState) {
        boolean stateChanged = this.currentState.set(StatsComponentImplBase.statsStateToState(Preconditions.checkNotNull(newState, "newState")));
        if (stateChanged) {
            if (newState == StatsCollectionState.DISABLED) {
                this.viewManager.clearStats();
            } else {
                this.viewManager.resumeStatsCollection();
            }
        }
    }

    private static CurrentState.State statsStateToState(StatsCollectionState statsCollectionState) {
        return statsCollectionState == StatsCollectionState.ENABLED ? CurrentState.State.ENABLED : CurrentState.State.DISABLED;
    }

    private static StatsCollectionState stateToStatsState(CurrentState.State state) {
        return state == CurrentState.State.ENABLED ? StatsCollectionState.ENABLED : StatsCollectionState.DISABLED;
    }
}

