/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GroupByKey<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final @UnknownKeyFor @NonNull @Initialized boolean fewKeys;

    private GroupByKey(@UnknownKeyFor @NonNull @Initialized boolean fewKeys) {
        this.fewKeys = fewKeys;
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> create() {
        return new GroupByKey<K, V>(false);
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized GroupByKey<K, V> createWithFewKeys() {
        return new GroupByKey<K, V>(true);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean fewKeys() {
        return this.fewKeys;
    }

    public static void applicableTo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
        WindowingStrategy<?, ?> windowingStrategy = input.getWindowingStrategy();
        if (windowingStrategy.getWindowFn() instanceof GlobalWindows && windowingStrategy.getTrigger() instanceof DefaultTrigger && input.isBounded() != PCollection.IsBounded.BOUNDED) {
            throw new IllegalStateException("GroupByKey cannot be applied to non-bounded PCollection in the GlobalWindow without a trigger. Use a Window.into or Window.triggering transform prior to GroupByKey.");
        }
        if (!GroupByKey.triggerIsSafe(windowingStrategy)) {
            throw new IllegalArgumentException(String.format("Unsafe trigger '%s' may lose data, did you mean to wrap it in`Repeatedly.forever(...)`?%nSee https://s.apache.org/finishing-triggers-drop-data for details.", windowingStrategy.getTrigger()));
        }
    }

    @Override
    public void validate(@Nullable @UnknownKeyFor @Initialized PipelineOptions options, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> inputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs) {
        PCollection input = (PCollection)Iterables.getOnlyElement(inputs.values());
        KvCoder<K, V> inputCoder = GroupByKey.getInputKvCoder(input.getCoder());
        Coder outputCoder = ((PCollection)Iterables.getOnlyElement(outputs.values())).getCoder();
        KvCoder<K, Iterable<V>> expectedOutputCoder = GroupByKey.getOutputKvCoder(inputCoder);
        if (!expectedOutputCoder.equals(outputCoder)) {
            throw new IllegalStateException(String.format("the GroupByKey requires its output coder to be %s but found %s.", expectedOutputCoder, outputCoder));
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean triggerIsSafe(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        if (!windowingStrategy.getTrigger().mayFinish()) {
            return true;
        }
        if (windowingStrategy.getTrigger() instanceof Never.NeverTrigger) {
            return true;
        }
        if (windowingStrategy.getTrigger() instanceof AfterWatermark.FromEndOfWindow && windowingStrategy.getAllowedLateness().getMillis() == 0L) {
            return true;
        }
        if (windowingStrategy.getTrigger() instanceof AfterWatermark.AfterWatermarkEarlyAndLate && windowingStrategy.getAllowedLateness().getMillis() == 0L) {
            return true;
        }
        return windowingStrategy.getTrigger() instanceof AfterWatermark.AfterWatermarkEarlyAndLate && ((AfterWatermark.AfterWatermarkEarlyAndLate)windowingStrategy.getTrigger()).getLateTrigger() != null;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> updateWindowingStrategy(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> inputStrategy) {
        return inputStrategy.withAlreadyMerged(!inputStrategy.getWindowFn().isNonMerging()).withTrigger(inputStrategy.getTrigger().getContinuationTrigger());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
        GroupByKey.applicableTo(input);
        Coder<K> keyCoder = GroupByKey.getKeyCoder(input.getCoder());
        try {
            keyCoder.verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            throw new IllegalStateException("the keyCoder of a GroupByKey must be deterministic", e);
        }
        return PCollection.createPrimitiveOutputInternal(input.getPipeline(), this.updateWindowingStrategy(input.getWindowingStrategy()), input.isBounded(), GroupByKey.getOutputKvCoder(input.getCoder()));
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> getInputKvCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputCoder) {
        if (!(inputCoder instanceof KvCoder)) {
            throw new IllegalStateException("GroupByKey requires its input to use KvCoder");
        }
        return (KvCoder)inputCoder;
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> inputCoder) {
        return GroupByKey.getInputKvCoder(inputCoder).getKeyCoder();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized Coder<V> getInputValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> inputCoder) {
        return GroupByKey.getInputKvCoder(inputCoder).getValueCoder();
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<V>> getOutputValueCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> inputCoder) {
        return IterableCoder.of(GroupByKey.getInputValueCoder(inputCoder));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized KvCoder<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>> getOutputKvCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<K, V>> inputCoder) {
        return KvCoder.of(GroupByKey.getKeyCoder(inputCoder), GroupByKey.getOutputValueCoder(inputCoder));
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        if (this.fewKeys) {
            builder.add(DisplayData.item("fewKeys", true).withLabel("Has Few Keys"));
        }
    }
}

