/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalCompactor;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalRecord;
import org.apache.activemq.artemis.core.journal.impl.JournalRecordProvider;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalTransaction
implements IOCallback {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JournalRecordProvider journal;
    private List<JournalUpdate> pos;
    private List<JournalUpdate> neg;
    private final long id;
    private Set<JournalFile> pendingFiles;
    private boolean compacting = false;
    private JournalFile lastFile = null;
    private volatile int counter;
    private static final AtomicIntegerFieldUpdater<JournalTransaction> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(JournalTransaction.class, "counter");
    private volatile String errorMessage = null;
    private volatile int errorCode = 0;
    private static final AtomicIntegerFieldUpdater<JournalTransaction> upUpdater = AtomicIntegerFieldUpdater.newUpdater(JournalTransaction.class, "up");
    private static final AtomicIntegerFieldUpdater<JournalTransaction> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(JournalTransaction.class, "done");
    private volatile int up;
    private volatile int done = 0;
    private volatile IOCallback delegateCompletion;

    public JournalTransaction(long id, JournalRecordProvider journal) {
        this.id = id;
        this.journal = journal;
    }

    public void replaceRecordProvider(JournalRecordProvider provider) {
        this.journal = provider;
    }

    public long getId() {
        return this.id;
    }

    public int getCounter(JournalFile file) {
        if (this.lastFile != file) {
            this.lastFile = file;
            counterUpdater.set(this, 0);
        }
        return counterUpdater.get(this);
    }

    public void incCounter(JournalFile file) {
        if (this.lastFile != file) {
            this.lastFile = file;
            counterUpdater.set(this, 0);
        }
        counterUpdater.incrementAndGet(this);
    }

    public long[] getPositiveArray() {
        if (this.pos == null) {
            return new long[0];
        }
        int i = 0;
        long[] ids = new long[this.pos.size()];
        for (JournalUpdate el : this.pos) {
            ids[i++] = el.getId();
        }
        return ids;
    }

    public void setCompacting() {
        this.compacting = true;
        this.clear();
    }

    public void merge(JournalTransaction other) {
        if (other.pos != null) {
            if (this.pos == null) {
                this.pos = new ArrayList<JournalUpdate>();
            }
            this.pos.addAll(other.pos);
        }
        if (other.neg != null) {
            if (this.neg == null) {
                this.neg = new ArrayList<JournalUpdate>();
            }
            this.neg.addAll(other.neg);
        }
        if (other.pendingFiles != null) {
            if (this.pendingFiles == null) {
                this.pendingFiles = new HashSet<JournalFile>();
            }
            this.pendingFiles.addAll(other.pendingFiles);
        }
        this.compacting = false;
    }

    public void clear() {
        if (this.pendingFiles != null) {
            this.pendingFiles.clear();
        }
        if (this.pos != null) {
            this.pos.clear();
        }
        if (this.neg != null) {
            this.neg.clear();
        }
        counterUpdater.set(this, 0);
        this.lastFile = null;
    }

    public void fillNumberOfRecords(JournalFile currentFile, JournalInternalRecord data) {
        data.setNumberOfRecords(this.getCounter(currentFile));
    }

    public void checkErrorCondition() throws Exception {
        if (this.getErrorMessage() != null) {
            throw ActiveMQExceptionType.createException((int)this.getErrorCode(), (String)this.getErrorMessage());
        }
    }

    public void addPositive(JournalFile file, long id, int size, boolean replaceableRecord) {
        this.incCounter(file);
        this.addFile(file);
        if (this.pos == null) {
            this.pos = new ArrayList<JournalUpdate>();
        }
        this.pos.add(new JournalUpdate(file, id, size, replaceableRecord));
    }

    public void addNegative(JournalFile file, long id) {
        this.incCounter(file);
        this.addFile(file);
        if (this.neg == null) {
            this.neg = new ArrayList<JournalUpdate>();
        }
        this.neg.add(new JournalUpdate(file, id, 0, false));
    }

    public void commit(JournalFile file) {
        JournalCompactor compactor = this.journal.getCompactor();
        if (this.compacting && compactor != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("adding txID={} into compacting", (Object)this.id);
            }
            compactor.addCommandCommit(this, file);
        } else {
            JournalRecord posFiles;
            if (logger.isTraceEnabled()) {
                logger.trace("there was no compactor on commit txID={}", (Object)this.id);
            }
            if (this.pos != null) {
                for (JournalUpdate trUpdate : this.pos) {
                    posFiles = (JournalRecord)this.journal.getRecords().get(trUpdate.id);
                    if (compactor != null && compactor.containsRecord(trUpdate.id)) {
                        compactor.addCommandUpdate(trUpdate.id, trUpdate.file, trUpdate.size, trUpdate.replaceableUpdate);
                        continue;
                    }
                    if (posFiles == null) {
                        posFiles = new JournalRecord(trUpdate.file, trUpdate.size);
                        this.journal.getRecords().put(trUpdate.id, (Object)posFiles);
                        continue;
                    }
                    posFiles.addUpdateFile(trUpdate.file, trUpdate.size, trUpdate.replaceableUpdate);
                }
            }
            if (this.neg != null) {
                for (JournalUpdate trDelete : this.neg) {
                    if (compactor != null) {
                        compactor.addCommandDelete(trDelete.id, trDelete.file);
                        continue;
                    }
                    posFiles = (JournalRecord)this.journal.getRecords().remove(trDelete.id);
                    if (posFiles == null) continue;
                    posFiles.delete(trDelete.file);
                }
            }
            for (JournalFile jf : this.pendingFiles) {
                file.incNegCount(jf);
            }
        }
    }

    public void rollback(JournalFile file) {
        JournalCompactor compactor = this.journal.getCompactor();
        if (this.compacting && compactor != null) {
            compactor.addCommandRollback(this, file);
        } else {
            for (JournalFile jf : this.pendingFiles) {
                file.incNegCount(jf);
            }
        }
    }

    public void prepare(JournalFile file) {
        this.addFile(file);
    }

    public void forget() {
        if (this.pendingFiles != null) {
            for (JournalFile jf : this.pendingFiles) {
                jf.decPosCount();
            }
        }
    }

    public String toString() {
        return "JournalTransaction(" + this.id + ")";
    }

    private void addFile(JournalFile file) {
        if (this.pendingFiles == null) {
            this.pendingFiles = new HashSet<JournalFile>();
        }
        if (!this.pendingFiles.contains(file)) {
            this.pendingFiles.add(file);
            file.incPosCount();
        }
    }

    public void countUp() {
        upUpdater.incrementAndGet(this);
    }

    @Override
    public void done() {
        if (doneUpdater.incrementAndGet(this) == upUpdater.get(this) && this.delegateCompletion != null) {
            IOCallback delegateToCall = this.delegateCompletion;
            this.delegateCompletion = null;
            delegateToCall.done();
        }
    }

    @Override
    public void onError(int errorCode, String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        if (this.delegateCompletion != null) {
            this.delegateCompletion.onError(errorCode, errorMessage);
        }
    }

    public IOCallback getDelegateCompletion() {
        return this.delegateCompletion;
    }

    public void setDelegateCompletion(IOCallback delegateCompletion) {
        this.delegateCompletion = delegateCompletion;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    private static class JournalUpdate {
        private final JournalFile file;
        long id;
        int size;
        final boolean replaceableUpdate;

        private JournalUpdate(JournalFile file, long id, int size, boolean replaceableUpdate) {
            this.file = file;
            this.id = id;
            this.size = size;
            this.replaceableUpdate = replaceableUpdate;
        }

        public long getId() {
            return this.id;
        }
    }
}

