/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.SseEventSink;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.sse.OutboundSseEventBodyWriter;
import org.apache.cxf.jaxrs.sse.SseEventSinkImpl;
import org.apache.cxf.message.Message;

public class SseEventSinkContextProvider
implements ContextProvider<SseEventSink> {
    public SseEventSink createContext(Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (request == null) {
            throw new IllegalStateException("Unable to retrieve HTTP request from the context");
        }
        OutboundSseEventBodyWriter writer = new OutboundSseEventBodyWriter(ServerProviderFactory.getInstance((Message)message), message.getExchange());
        AsyncResponseImpl async = new AsyncResponseImpl(message);
        Integer bufferSize = PropertyUtils.getInteger((Message)message, (String)"org.apache.cxf.sse.sink.buffer.size");
        SseEventSink sink = this.createSseEventSink(request, writer, (AsyncResponse)async, bufferSize);
        message.put(SseEventSink.class, (Object)sink);
        return sink;
    }

    protected SseEventSink createSseEventSink(HttpServletRequest request, MessageBodyWriter<OutboundSseEvent> writer, AsyncResponse async, Integer bufferSize) {
        if (bufferSize != null) {
            return new SseEventSinkImpl(writer, async, request.getAsyncContext(), bufferSize);
        }
        return new SseEventSinkImpl(writer, async, request.getAsyncContext());
    }
}

