/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Store and query vector embeddings using AWS S3 Vectors with similarity
 * search.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AWS2S3VectorsEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the AWS S3 Vectors component.
     */
    public interface AWS2S3VectorsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder advanced() {
            return (AdvancedAWS2S3VectorsEndpointConsumerBuilder) this;
        }
        /**
         * The data type of the vector. Options: float32, float16.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: float32
         * Group: common
         * 
         * @param dataType the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder dataType(String dataType) {
            doSetProperty("dataType", dataType);
            return this;
        }
        /**
         * The distance metric to use for similarity search. Options: cosine,
         * euclidean, dot-product.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: cosine
         * Group: common
         * 
         * @param distanceMetric the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder distanceMetric(String distanceMetric) {
            doSetProperty("distanceMetric", distanceMetric);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * The region in which S3 Vectors client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The minimum similarity threshold for results.
         * 
         * The option is a: <code>java.lang.Float</code> type.
         * 
         * Group: common
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder similarityThreshold(Float similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * The minimum similarity threshold for results.
         * 
         * The option will be converted to a <code>java.lang.Float</code> type.
         * 
         * Group: common
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder similarityThreshold(String similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * The number of top similar vectors to return in a query.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10
         * Group: common
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder topK(Integer topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * The number of top similar vectors to return in a query.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10
         * Group: common
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder topK(String topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * The dimensions of the vector embeddings (default: 1536, which is the
         * dimension for OpenAI text-embedding-3-small).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1536
         * Group: common
         * 
         * @param vectorDimensions the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder vectorDimensions(Integer vectorDimensions) {
            doSetProperty("vectorDimensions", vectorDimensions);
            return this;
        }
        /**
         * The dimensions of the vector embeddings (default: 1536, which is the
         * dimension for OpenAI text-embedding-3-small).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 1536
         * Group: common
         * 
         * @param vectorDimensions the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder vectorDimensions(String vectorDimensions) {
            doSetProperty("vectorDimensions", vectorDimensions);
            return this;
        }
        /**
         * The name of the vector index.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param vectorIndexName the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder vectorIndexName(String vectorIndexName) {
            doSetProperty("vectorIndexName", vectorIndexName);
            return this;
        }
        /**
         * Optional metadata filter for the consumer to filter vectors during
         * polling.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param consumerMetadataFilter the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder consumerMetadataFilter(String consumerMetadataFilter) {
            doSetProperty("consumerMetadataFilter", consumerMetadataFilter);
            return this;
        }
        /**
         * The query vector to use for the consumer to poll for similar vectors.
         * Specified as comma-separated float values (e.g., 0.1,0.2,0.3). If not
         * specified, the consumer will not poll.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param consumerQueryVector the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder consumerQueryVector(String consumerQueryVector) {
            doSetProperty("consumerQueryVector", consumerQueryVector);
            return this;
        }
        /**
         * Milliseconds before the next poll for the consumer.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll for the consumer.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Delete vectors after they have been consumed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder deleteAfterRead(boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Delete vectors after they have been consumed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * The maximum number of messages to consume per poll for the consumer.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * The maximum number of messages to consume per poll for the consumer.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * To define a proxy host when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the S3 Vectors client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 Vectors client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder runLoggingLevel(org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a default credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a default credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in S3 Vectors.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in S3 Vectors.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointConsumerBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AWS S3 Vectors component.
     */
    public interface AdvancedAWS2S3VectorsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AWS2S3VectorsEndpointConsumerBuilder basic() {
            return (AWS2S3VectorsEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder pollStrategy(org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Reference to a
         * software.amazon.awssdk.services.s3vectors.S3VectorsClient in the
         * registry.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3vectors.S3VectorsClient</code> type.
         * 
         * Group: advanced
         * 
         * @param s3VectorsClient the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder s3VectorsClient(software.amazon.awssdk.services.s3vectors.S3VectorsClient s3VectorsClient) {
            doSetProperty("s3VectorsClient", s3VectorsClient);
            return this;
        }
        /**
         * Reference to a
         * software.amazon.awssdk.services.s3vectors.S3VectorsClient in the
         * registry.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3vectors.S3VectorsClient</code> type.
         * 
         * Group: advanced
         * 
         * @param s3VectorsClient the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointConsumerBuilder s3VectorsClient(String s3VectorsClient) {
            doSetProperty("s3VectorsClient", s3VectorsClient);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AWS S3 Vectors component.
     */
    public interface AWS2S3VectorsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAWS2S3VectorsEndpointProducerBuilder advanced() {
            return (AdvancedAWS2S3VectorsEndpointProducerBuilder) this;
        }

        /**
         * The data type of the vector. Options: float32, float16.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: float32
         * Group: common
         * 
         * @param dataType the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder dataType(String dataType) {
            doSetProperty("dataType", dataType);
            return this;
        }
        /**
         * The distance metric to use for similarity search. Options: cosine,
         * euclidean, dot-product.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: cosine
         * Group: common
         * 
         * @param distanceMetric the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder distanceMetric(String distanceMetric) {
            doSetProperty("distanceMetric", distanceMetric);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * The region in which S3 Vectors client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The minimum similarity threshold for results.
         * 
         * The option is a: <code>java.lang.Float</code> type.
         * 
         * Group: common
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder similarityThreshold(Float similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * The minimum similarity threshold for results.
         * 
         * The option will be converted to a <code>java.lang.Float</code> type.
         * 
         * Group: common
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder similarityThreshold(String similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * The number of top similar vectors to return in a query.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10
         * Group: common
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder topK(Integer topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * The number of top similar vectors to return in a query.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10
         * Group: common
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder topK(String topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * The dimensions of the vector embeddings (default: 1536, which is the
         * dimension for OpenAI text-embedding-3-small).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1536
         * Group: common
         * 
         * @param vectorDimensions the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder vectorDimensions(Integer vectorDimensions) {
            doSetProperty("vectorDimensions", vectorDimensions);
            return this;
        }
        /**
         * The dimensions of the vector embeddings (default: 1536, which is the
         * dimension for OpenAI text-embedding-3-small).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 1536
         * Group: common
         * 
         * @param vectorDimensions the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder vectorDimensions(String vectorDimensions) {
            doSetProperty("vectorDimensions", vectorDimensions);
            return this;
        }
        /**
         * The name of the vector index.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param vectorIndexName the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder vectorIndexName(String vectorIndexName) {
            doSetProperty("vectorIndexName", vectorIndexName);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder operation(org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * To define a proxy host when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the S3 Vectors client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 Vectors client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a default credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a default credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in S3 Vectors.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in S3 Vectors.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointProducerBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AWS S3 Vectors component.
     */
    public interface AdvancedAWS2S3VectorsEndpointProducerBuilder extends EndpointProducerBuilder {
        default AWS2S3VectorsEndpointProducerBuilder basic() {
            return (AWS2S3VectorsEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Reference to a
         * software.amazon.awssdk.services.s3vectors.S3VectorsClient in the
         * registry.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3vectors.S3VectorsClient</code> type.
         * 
         * Group: advanced
         * 
         * @param s3VectorsClient the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointProducerBuilder s3VectorsClient(software.amazon.awssdk.services.s3vectors.S3VectorsClient s3VectorsClient) {
            doSetProperty("s3VectorsClient", s3VectorsClient);
            return this;
        }
        /**
         * Reference to a
         * software.amazon.awssdk.services.s3vectors.S3VectorsClient in the
         * registry.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3vectors.S3VectorsClient</code> type.
         * 
         * Group: advanced
         * 
         * @param s3VectorsClient the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointProducerBuilder s3VectorsClient(String s3VectorsClient) {
            doSetProperty("s3VectorsClient", s3VectorsClient);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AWS S3 Vectors component.
     */
    public interface AWS2S3VectorsEndpointBuilder
            extends
                AWS2S3VectorsEndpointConsumerBuilder,
                AWS2S3VectorsEndpointProducerBuilder {
        default AdvancedAWS2S3VectorsEndpointBuilder advanced() {
            return (AdvancedAWS2S3VectorsEndpointBuilder) this;
        }

        /**
         * The data type of the vector. Options: float32, float16.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: float32
         * Group: common
         * 
         * @param dataType the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder dataType(String dataType) {
            doSetProperty("dataType", dataType);
            return this;
        }
        /**
         * The distance metric to use for similarity search. Options: cosine,
         * euclidean, dot-product.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: cosine
         * Group: common
         * 
         * @param distanceMetric the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder distanceMetric(String distanceMetric) {
            doSetProperty("distanceMetric", distanceMetric);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * The region in which S3 Vectors client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The minimum similarity threshold for results.
         * 
         * The option is a: <code>java.lang.Float</code> type.
         * 
         * Group: common
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder similarityThreshold(Float similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * The minimum similarity threshold for results.
         * 
         * The option will be converted to a <code>java.lang.Float</code> type.
         * 
         * Group: common
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder similarityThreshold(String similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
        /**
         * The number of top similar vectors to return in a query.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 10
         * Group: common
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder topK(Integer topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * The number of top similar vectors to return in a query.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 10
         * Group: common
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder topK(String topK) {
            doSetProperty("topK", topK);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * The dimensions of the vector embeddings (default: 1536, which is the
         * dimension for OpenAI text-embedding-3-small).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Default: 1536
         * Group: common
         * 
         * @param vectorDimensions the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder vectorDimensions(Integer vectorDimensions) {
            doSetProperty("vectorDimensions", vectorDimensions);
            return this;
        }
        /**
         * The dimensions of the vector embeddings (default: 1536, which is the
         * dimension for OpenAI text-embedding-3-small).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Default: 1536
         * Group: common
         * 
         * @param vectorDimensions the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder vectorDimensions(String vectorDimensions) {
            doSetProperty("vectorDimensions", vectorDimensions);
            return this;
        }
        /**
         * The name of the vector index.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param vectorIndexName the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder vectorIndexName(String vectorIndexName) {
            doSetProperty("vectorIndexName", vectorIndexName);
            return this;
        }
        /**
         * To define a proxy host when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the S3 Vectors client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 Vectors client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the S3 Vectors client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a default credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a default credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in S3 Vectors.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the S3 Vectors client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in S3 Vectors.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS S3 Vectors component.
     */
    public interface AdvancedAWS2S3VectorsEndpointBuilder
            extends
                AdvancedAWS2S3VectorsEndpointConsumerBuilder,
                AdvancedAWS2S3VectorsEndpointProducerBuilder {
        default AWS2S3VectorsEndpointBuilder basic() {
            return (AWS2S3VectorsEndpointBuilder) this;
        }

        /**
         * Reference to a
         * software.amazon.awssdk.services.s3vectors.S3VectorsClient in the
         * registry.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.s3vectors.S3VectorsClient</code> type.
         * 
         * Group: advanced
         * 
         * @param s3VectorsClient the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointBuilder s3VectorsClient(software.amazon.awssdk.services.s3vectors.S3VectorsClient s3VectorsClient) {
            doSetProperty("s3VectorsClient", s3VectorsClient);
            return this;
        }
        /**
         * Reference to a
         * software.amazon.awssdk.services.s3vectors.S3VectorsClient in the
         * registry.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.s3vectors.S3VectorsClient</code> type.
         * 
         * Group: advanced
         * 
         * @param s3VectorsClient the value to set
         * @return the dsl builder
         */
        default AdvancedAWS2S3VectorsEndpointBuilder s3VectorsClient(String s3VectorsClient) {
            doSetProperty("s3VectorsClient", s3VectorsClient);
            return this;
        }
    }

    public interface AWS2S3VectorsBuilders {
        /**
         * AWS S3 Vectors (camel-aws2-s3-vectors)
         * Store and query vector embeddings using AWS S3 Vectors with
         * similarity search.
         * 
         * Category: cloud,ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-aws2-s3-vectors
         * 
         * @return the dsl builder for the headers' name.
         */
        default AWS2S3VectorsHeaderNameBuilder aws2S3Vectors() {
            return AWS2S3VectorsHeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS S3 Vectors (camel-aws2-s3-vectors)
         * Store and query vector embeddings using AWS S3 Vectors with
         * similarity search.
         * 
         * Category: cloud,ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-aws2-s3-vectors
         * 
         * Syntax: <code>aws2-s3-vectors://vectorBucketName</code>
         * 
         * Path parameter: vectorBucketName (required)
         * Vector bucket name or ARN
         * 
         * @param path vectorBucketName
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder aws2S3Vectors(String path) {
            return AWS2S3VectorsEndpointBuilderFactory.endpointBuilder("aws2-s3-vectors", path);
        }
        /**
         * AWS S3 Vectors (camel-aws2-s3-vectors)
         * Store and query vector embeddings using AWS S3 Vectors with
         * similarity search.
         * 
         * Category: cloud,ai
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-aws2-s3-vectors
         * 
         * Syntax: <code>aws2-s3-vectors://vectorBucketName</code>
         * 
         * Path parameter: vectorBucketName (required)
         * Vector bucket name or ARN
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path vectorBucketName
         * @return the dsl builder
         */
        default AWS2S3VectorsEndpointBuilder aws2S3Vectors(String componentName, String path) {
            return AWS2S3VectorsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS S3 Vectors component.
     */
    public static class AWS2S3VectorsHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final AWS2S3VectorsHeaderNameBuilder INSTANCE = new AWS2S3VectorsHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3VectorsOperation}.
         */
        public String awsS3VectorsOperation() {
            return "CamelAwsS3VectorsOperation";
        }
        /**
         * The name of the vector bucket which will be used for the current
         * operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3VectorsVectorBucketName}.
         */
        public String awsS3VectorsVectorBucketName() {
            return "CamelAwsS3VectorsVectorBucketName";
        }
        /**
         * The name of the vector index which will be used for the current
         * operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AwsS3VectorsVectorIndexName}.
         */
        public String awsS3VectorsVectorIndexName() {
            return "CamelAwsS3VectorsVectorIndexName";
        }
        /**
         * The unique identifier for a vector.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsVectorId}.
         */
        public String awsS3VectorsVectorId() {
            return "CamelAwsS3VectorsVectorId";
        }
        /**
         * The vector embedding data as a list of floats or float array.
         * 
         * The option is a: {@code List<Float> or float[]} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsVectorData}.
         */
        public String awsS3VectorsVectorData() {
            return "CamelAwsS3VectorsVectorData";
        }
        /**
         * The dimensions of the vector.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsVectorDimensions}.
         */
        public String awsS3VectorsVectorDimensions() {
            return "CamelAwsS3VectorsVectorDimensions";
        }
        /**
         * The data type of the vector (float32 or float16).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsDataType}.
         */
        public String awsS3VectorsDataType() {
            return "CamelAwsS3VectorsDataType";
        }
        /**
         * Additional metadata for the vector as a map.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsVectorMetadata}.
         */
        public String awsS3VectorsVectorMetadata() {
            return "CamelAwsS3VectorsVectorMetadata";
        }
        /**
         * The query vector for similarity search as a list of floats or float
         * array.
         * 
         * The option is a: {@code List<Float> or float[]} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsQueryVector}.
         */
        public String awsS3VectorsQueryVector() {
            return "CamelAwsS3VectorsQueryVector";
        }
        /**
         * The number of top similar vectors to return.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsTopK}.
         */
        public String awsS3VectorsTopK() {
            return "CamelAwsS3VectorsTopK";
        }
        /**
         * The distance metric to use for similarity search (cosine, euclidean,
         * dot-product).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsDistanceMetric}.
         */
        public String awsS3VectorsDistanceMetric() {
            return "CamelAwsS3VectorsDistanceMetric";
        }
        /**
         * The minimum similarity threshold for results.
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsS3VectorsSimilarityThreshold}.
         */
        public String awsS3VectorsSimilarityThreshold() {
            return "CamelAwsS3VectorsSimilarityThreshold";
        }
        /**
         * Optional filter expression for metadata filtering during vector
         * search.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsS3VectorsMetadataFilter}.
         */
        public String awsS3VectorsMetadataFilter() {
            return "CamelAwsS3VectorsMetadataFilter";
        }
        /**
         * The similarity score of the returned vector.
         * 
         * The option is a: {@code Float} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AwsS3VectorsSimilarityScore}.
         */
        public String awsS3VectorsSimilarityScore() {
            return "CamelAwsS3VectorsSimilarityScore";
        }
        /**
         * The number of vectors returned in the result.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AwsS3VectorsResultCount}.
         */
        public String awsS3VectorsResultCount() {
            return "CamelAwsS3VectorsResultCount";
        }
        /**
         * The status of the vector index.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AwsS3VectorsIndexStatus}.
         */
        public String awsS3VectorsIndexStatus() {
            return "CamelAwsS3VectorsIndexStatus";
        }
        /**
         * The ARN of the vector bucket.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AwsS3VectorsVectorBucketArn}.
         */
        public String awsS3VectorsVectorBucketArn() {
            return "CamelAwsS3VectorsVectorBucketArn";
        }
    }
    static AWS2S3VectorsEndpointBuilder endpointBuilder(String componentName, String path) {
        class AWS2S3VectorsEndpointBuilderImpl extends AbstractEndpointBuilder implements AWS2S3VectorsEndpointBuilder, AdvancedAWS2S3VectorsEndpointBuilder {
            public AWS2S3VectorsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new AWS2S3VectorsEndpointBuilderImpl(path);
    }
}