/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util.introspect.support;

import io.hawt.util.introspect.support.ClassScanner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Packages {
    private static final Logger LOG = LoggerFactory.getLogger(Packages.class);

    public static Package[] findPackagesForClassLoader(ClassLoader loader) {
        IntrospectClassLoader introspectClassLoader = new IntrospectClassLoader(loader);
        return introspectClassLoader.getPackages();
    }

    public static Map<Package, ClassLoader[]> getPackageMap(List<ClassLoader> classLoaders, Set<String> ignorePackages) {
        HashMap<Package, ClassLoader[]> answer = new HashMap<Package, ClassLoader[]>();
        ClassLoader[] globalClassLoaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassScanner.class.getClassLoader()};
        HashSet packages = new HashSet();
        Packages.add(answer, Package.getPackages(), globalClassLoaders, ignorePackages);
        ClassLoader[] classLoaderArray = new ClassLoader[classLoaders.size()];
        classLoaders.toArray(classLoaderArray);
        for (ClassLoader classLoader : classLoaders) {
            Package[] loaderPackages = Packages.findPackagesForClassLoader(classLoader);
            Packages.add(answer, loaderPackages, classLoaderArray, ignorePackages);
        }
        TreeSet<String> names = new TreeSet<String>();
        for (Package aPackage : packages) {
            names.add(aPackage.getName());
        }
        for (String name : names) {
            LOG.info("Got package " + name);
        }
        return answer;
    }

    protected static void add(Map<Package, ClassLoader[]> answer, Package[] packages, ClassLoader[] classLoaders, Set<String> ignorePackages) {
        if (packages != null) {
            for (Package aPackage : packages) {
                String name = aPackage.getName();
                if (ignorePackages.contains(name)) continue;
                answer.put(aPackage, classLoaders);
            }
        }
    }

    protected static class IntrospectClassLoader
    extends ClassLoader {
        public IntrospectClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Package[] getPackages() {
            return super.getPackages();
        }

        @Override
        public Package getPackage(String name) {
            return super.getPackage(name);
        }
    }
}

