/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.ext.javatime.ser.JSR310FormattedSerializerBase;
import tools.jackson.databind.jsontype.TypeSerializer;

public class MonthSerializer
extends JSR310FormattedSerializerBase<Month> {
    public static final MonthSerializer INSTANCE = new MonthSerializer();

    protected MonthSerializer() {
        this((DateTimeFormatter)null);
    }

    public MonthSerializer(DateTimeFormatter formatter) {
        super(Month.class, formatter);
    }

    private MonthSerializer(MonthSerializer base, DateTimeFormatter dtf, Boolean useTimestamp) {
        super(base, dtf, useTimestamp, null, null);
    }

    protected MonthSerializer withFormat(DateTimeFormatter dtf, Boolean useTimestamp, JsonFormat.Shape shape) {
        return new MonthSerializer(this, dtf, useTimestamp);
    }

    @Override
    public void serialize(Month value, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._useTimestampExplicitOnly(ctxt)) {
            g.writeStartArray();
            this._serialize(g, value, ctxt);
            g.writeEndArray();
        } else {
            this._serialize(g, value, ctxt);
        }
    }

    @Override
    public void serializeWithType(Month value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, this.serializationShape(ctxt)));
        if (typeIdDef != null && typeIdDef.valueShape == JsonToken.START_ARRAY) {
            this._serialize(g, value, ctxt);
        } else {
            this._serialize(g, value, ctxt);
        }
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    @Override
    protected JsonToken serializationShape(SerializationContext ctxt) {
        return this._useTimestampExplicitOnly(ctxt) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    private void _serialize(JsonGenerator g, Month value, SerializationContext ctxt) throws JacksonException {
        if (this._formatter != null) {
            g.writeString(this._formatter.format(value));
            return;
        }
        if (ctxt.isEnabled(DateTimeFeature.ONE_BASED_MONTHS)) {
            g.writeNumber(value.getValue());
        } else {
            g.writeNumber(value.getValue() - 1);
        }
    }
}

