/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jdk;

import java.util.Arrays;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.BeanDeserializer;
import tools.jackson.databind.deser.bean.BeanPropertyMap;
import tools.jackson.databind.deser.bean.PropertyBasedCreator;
import tools.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import tools.jackson.databind.util.NameTransformer;

public class ThrowableDeserializer
extends BeanDeserializer {
    protected static final String PROP_NAME_MESSAGE = "message";
    protected static final String PROP_NAME_SUPPRESSED = "suppressed";
    protected static final String PROP_NAME_LOCALIZED_MESSAGE = "localizedMessage";

    protected ThrowableDeserializer(BeanDeserializer baseDeserializer) {
        super(baseDeserializer);
        this._vanillaProcessing = false;
    }

    public static ThrowableDeserializer construct(DeserializationContext ctxt, BeanDeserializer baseDeserializer) {
        return new ThrowableDeserializer(baseDeserializer);
    }

    protected ThrowableDeserializer(BeanDeserializer src, UnwrappedPropertyHandler unwrapHandler, PropertyBasedCreator pbCreator, BeanPropertyMap renamedProperties, boolean ignoreAllUnknown) {
        super(src, unwrapHandler, pbCreator, renamedProperties, ignoreAllUnknown);
    }

    @Override
    public ValueDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer transformer) {
        PropertyBasedCreator pbCreator;
        if (this.getClass() != ThrowableDeserializer.class) {
            return this;
        }
        UnwrappedPropertyHandler uwHandler = this._unwrappedPropertyHandler;
        if (uwHandler != null) {
            uwHandler = uwHandler.renameAll(ctxt, transformer);
        }
        if ((pbCreator = this._propertyBasedCreator) != null) {
            pbCreator = pbCreator.renameAll(ctxt, transformer);
        }
        return new ThrowableDeserializer(this, uwHandler, pbCreator, this._beanProperties.renameAll(ctxt, transformer), true);
    }

    @Override
    public Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(p, ctxt);
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p, ctxt));
        }
        if (this._beanType.isAbstract()) {
            return ctxt.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), p, "abstract type (need to add/enable type information?)", new Object[0]);
        }
        boolean hasStringCreator = this._valueInstantiator.canCreateFromString();
        boolean hasDefaultCtor = this._valueInstantiator.canCreateUsingDefault();
        if (!hasStringCreator && !hasDefaultCtor) {
            return ctxt.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), p, "Throwable needs a default constructor, a single-String-arg constructor; or explicit @JsonCreator", new Object[0]);
        }
        Throwable throwable = null;
        Object[] pending = null;
        Throwable[] suppressed = null;
        int pendingIx = 0;
        int ix = p.currentNameMatch(this._propNameMatcher);
        while (true) {
            if (ix >= 0) {
                p.nextToken();
                SettableBeanProperty prop = this._propsByIndex[ix];
                if (throwable != null) {
                    if (!"cause".equals(prop.getName()) || !p.hasToken(JsonToken.VALUE_NULL)) {
                        prop.deserializeAndSet(p, ctxt, throwable);
                    }
                } else {
                    if (pending == null) {
                        int len = this._beanProperties.size();
                        pending = new Object[len + len];
                    } else if (pendingIx == pending.length) {
                        pending = Arrays.copyOf(pending, pendingIx + 16);
                    }
                    pending[pendingIx++] = prop;
                    pending[pendingIx++] = prop.deserialize(p, ctxt);
                }
            } else {
                if (ix != -2) {
                    if (ix == -1) break;
                    return this._handleUnexpectedWithin(p, ctxt, throwable);
                }
                String propName = p.currentName();
                p.nextToken();
                if (PROP_NAME_MESSAGE.equalsIgnoreCase(propName)) {
                    throwable = this._instantiate(ctxt, hasStringCreator, p.getValueAsString());
                    if (pending != null) {
                        int len = pendingIx;
                        for (int i = 0; i < len; i += 2) {
                            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)pending[i];
                            settableBeanProperty.set(ctxt, throwable, pending[i + 1]);
                        }
                        pending = null;
                    }
                } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    p.skipChildren();
                } else if (PROP_NAME_SUPPRESSED.equalsIgnoreCase(propName)) {
                    if (p.hasToken(JsonToken.VALUE_NULL)) {
                        suppressed = null;
                    } else {
                        ValueDeserializer<Object> deser = ctxt.findRootValueDeserializer(ctxt.constructType(Throwable[].class));
                        suppressed = (Throwable[])deser.deserialize(p, ctxt);
                    }
                } else if (PROP_NAME_LOCALIZED_MESSAGE.equalsIgnoreCase(propName)) {
                    p.skipChildren();
                } else if (this._anySetter != null) {
                    if (throwable == null) {
                        throwable = this._instantiate(ctxt, hasStringCreator, null);
                    }
                    this._anySetter.deserializeAndSet(p, ctxt, throwable, propName);
                } else if (PROP_NAME_MESSAGE.equalsIgnoreCase(propName)) {
                    p.skipChildren();
                } else {
                    this.handleUnknownProperty(p, ctxt, throwable, propName);
                }
            }
            ix = p.nextNameMatch(this._propNameMatcher);
        }
        if (throwable == null) {
            throwable = this._instantiate(ctxt, hasStringCreator, null);
        }
        if (pending != null) {
            int len = pendingIx;
            for (int i = 0; i < len; i += 2) {
                SettableBeanProperty prop = (SettableBeanProperty)pending[i];
                prop.set(ctxt, throwable, pending[i + 1]);
            }
        }
        if (suppressed != null) {
            for (void var13_24 : suppressed) {
                if (var13_24 == null) continue;
                throwable.addSuppressed((Throwable)var13_24);
            }
        }
        return throwable;
    }

    private Throwable _instantiate(DeserializationContext ctxt, boolean hasStringCreator, String valueAsString) {
        if (hasStringCreator) {
            if (valueAsString != null) {
                return (Throwable)this._valueInstantiator.createFromString(ctxt, valueAsString);
            }
            return (Throwable)this._valueInstantiator.createFromString(ctxt, null);
        }
        return (Throwable)this._valueInstantiator.createUsingDefault(ctxt);
    }
}

