/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.aggregation;

import java.math.BigDecimal;
import java.util.List;
import java.util.OptionalDouble;
import org.apache.qpid.server.query.engine.parsing.collector.CollectorType;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AbstractAggregationExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class AvgExpression<T>
extends AbstractAggregationExpression<T, Double> {
    private final FunctionParameterTypePredicate<Object> _typeValidator = FunctionParameterTypePredicate.builder().allowNumbers().build();

    public AvgExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(1, args, this);
    }

    @Override
    public CollectorType getCollectorType() {
        return CollectorType.AVERAGING;
    }

    @Override
    public Double aggregate(List<T> items) {
        List<?> args = this.getArguments(items, this._typeValidator);
        OptionalDouble optionalDouble = args.stream().mapToDouble(NumberConverter::toDouble).average();
        return optionalDouble.isPresent() ? (Double)NumberConverter.narrow(BigDecimal.valueOf(optionalDouble.getAsDouble())) : null;
    }
}

