/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum BVLCResultCode {
  SUCCESSFUL_COMPLETION((int) 0x0000),
  WRITE_BROADCAST_DISTRIBUTION_TABLE_NAK((int) 0x0010),
  READ_BROADCAST_DISTRIBUTION_TABLE_NAK((int) 0x0020),
  REGISTER_FOREIGN_DEVICE_NAK((int) 0x0030),
  READ_FOREIGN_DEVICE_TABLE_NAK((int) 0x0040),
  DELETE_FOREIGN_DEVICE_TABLE_ENTRY_NAK((int) 0x0050),
  DISTRIBUTE_BROADCAST_TO_NETWORK_NAK((int) 0x0060);
  private static final Map<Integer, BVLCResultCode> map;

  static {
    map = new HashMap<>();
    for (BVLCResultCode value : BVLCResultCode.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  BVLCResultCode(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static BVLCResultCode enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
