/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableEnum is an enum
type OpcuaNodeIdServicesVariableEnum int32

type IOpcuaNodeIdServicesVariableEnum interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableEnum_EnumValues  OpcuaNodeIdServicesVariableEnum = 3071
	OpcuaNodeIdServicesVariableEnum_EnumStrings OpcuaNodeIdServicesVariableEnum = 11432
)

var OpcuaNodeIdServicesVariableEnumValues []OpcuaNodeIdServicesVariableEnum

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableEnumValues = []OpcuaNodeIdServicesVariableEnum{
		OpcuaNodeIdServicesVariableEnum_EnumValues,
		OpcuaNodeIdServicesVariableEnum_EnumStrings,
	}
}

func OpcuaNodeIdServicesVariableEnumByValue(value int32) (enum OpcuaNodeIdServicesVariableEnum, ok bool) {
	switch value {
	case 11432:
		return OpcuaNodeIdServicesVariableEnum_EnumStrings, true
	case 3071:
		return OpcuaNodeIdServicesVariableEnum_EnumValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableEnumByName(value string) (enum OpcuaNodeIdServicesVariableEnum, ok bool) {
	switch value {
	case "EnumStrings":
		return OpcuaNodeIdServicesVariableEnum_EnumStrings, true
	case "EnumValues":
		return OpcuaNodeIdServicesVariableEnum_EnumValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableEnumKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableEnumValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableEnum(structType any) OpcuaNodeIdServicesVariableEnum {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableEnum {
		if sOpcuaNodeIdServicesVariableEnum, ok := typ.(OpcuaNodeIdServicesVariableEnum); ok {
			return sOpcuaNodeIdServicesVariableEnum
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableEnum) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableEnum) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableEnumParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableEnum, error) {
	return OpcuaNodeIdServicesVariableEnumParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableEnumParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableEnum, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableEnum", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableEnum")
	}
	if enum, ok := OpcuaNodeIdServicesVariableEnumByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableEnum")
		return OpcuaNodeIdServicesVariableEnum(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableEnum) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableEnum) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableEnum", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableEnum) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableEnum) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableEnum_EnumStrings:
		return "EnumStrings"
	case OpcuaNodeIdServicesVariableEnum_EnumValues:
		return "EnumValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableEnum) String() string {
	return e.PLC4XEnumName()
}
