/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyValues is the corresponding interface of BACnetPropertyValues
type BACnetPropertyValues interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetInnerOpeningTag returns InnerOpeningTag (property field)
	GetInnerOpeningTag() BACnetOpeningTag
	// GetData returns Data (property field)
	GetData() []BACnetPropertyValue
	// GetInnerClosingTag returns InnerClosingTag (property field)
	GetInnerClosingTag() BACnetClosingTag
	// IsBACnetPropertyValues is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyValues()
	// CreateBuilder creates a BACnetPropertyValuesBuilder
	CreateBACnetPropertyValuesBuilder() BACnetPropertyValuesBuilder
}

// _BACnetPropertyValues is the data-structure of this message
type _BACnetPropertyValues struct {
	InnerOpeningTag BACnetOpeningTag
	Data            []BACnetPropertyValue
	InnerClosingTag BACnetClosingTag

	// Arguments.
	TagNumber          uint8
	ObjectTypeArgument BACnetObjectType
}

var _ BACnetPropertyValues = (*_BACnetPropertyValues)(nil)

// NewBACnetPropertyValues factory function for _BACnetPropertyValues
func NewBACnetPropertyValues(innerOpeningTag BACnetOpeningTag, data []BACnetPropertyValue, innerClosingTag BACnetClosingTag, tagNumber uint8, objectTypeArgument BACnetObjectType) *_BACnetPropertyValues {
	if innerOpeningTag == nil {
		panic("innerOpeningTag of type BACnetOpeningTag for BACnetPropertyValues must not be nil")
	}
	if innerClosingTag == nil {
		panic("innerClosingTag of type BACnetClosingTag for BACnetPropertyValues must not be nil")
	}
	return &_BACnetPropertyValues{InnerOpeningTag: innerOpeningTag, Data: data, InnerClosingTag: innerClosingTag, TagNumber: tagNumber, ObjectTypeArgument: objectTypeArgument}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyValuesBuilder is a builder for BACnetPropertyValues
type BACnetPropertyValuesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(innerOpeningTag BACnetOpeningTag, data []BACnetPropertyValue, innerClosingTag BACnetClosingTag) BACnetPropertyValuesBuilder
	// WithInnerOpeningTag adds InnerOpeningTag (property field)
	WithInnerOpeningTag(BACnetOpeningTag) BACnetPropertyValuesBuilder
	// WithInnerOpeningTagBuilder adds InnerOpeningTag (property field) which is build by the builder
	WithInnerOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetPropertyValuesBuilder
	// WithData adds Data (property field)
	WithData(...BACnetPropertyValue) BACnetPropertyValuesBuilder
	// WithInnerClosingTag adds InnerClosingTag (property field)
	WithInnerClosingTag(BACnetClosingTag) BACnetPropertyValuesBuilder
	// WithInnerClosingTagBuilder adds InnerClosingTag (property field) which is build by the builder
	WithInnerClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetPropertyValuesBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetPropertyValuesBuilder
	// WithArgObjectTypeArgument sets a parser argument
	WithArgObjectTypeArgument(BACnetObjectType) BACnetPropertyValuesBuilder
	// Build builds the BACnetPropertyValues or returns an error if something is wrong
	Build() (BACnetPropertyValues, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyValues
}

// NewBACnetPropertyValuesBuilder() creates a BACnetPropertyValuesBuilder
func NewBACnetPropertyValuesBuilder() BACnetPropertyValuesBuilder {
	return &_BACnetPropertyValuesBuilder{_BACnetPropertyValues: new(_BACnetPropertyValues)}
}

type _BACnetPropertyValuesBuilder struct {
	*_BACnetPropertyValues

	collectedErr []error
}

var _ (BACnetPropertyValuesBuilder) = (*_BACnetPropertyValuesBuilder)(nil)

func (b *_BACnetPropertyValuesBuilder) WithMandatoryFields(innerOpeningTag BACnetOpeningTag, data []BACnetPropertyValue, innerClosingTag BACnetClosingTag) BACnetPropertyValuesBuilder {
	return b.WithInnerOpeningTag(innerOpeningTag).WithData(data...).WithInnerClosingTag(innerClosingTag)
}

func (b *_BACnetPropertyValuesBuilder) WithInnerOpeningTag(innerOpeningTag BACnetOpeningTag) BACnetPropertyValuesBuilder {
	b.InnerOpeningTag = innerOpeningTag
	return b
}

func (b *_BACnetPropertyValuesBuilder) WithInnerOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetPropertyValuesBuilder {
	builder := builderSupplier(b.InnerOpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.InnerOpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyValuesBuilder) WithData(data ...BACnetPropertyValue) BACnetPropertyValuesBuilder {
	b.Data = data
	return b
}

func (b *_BACnetPropertyValuesBuilder) WithInnerClosingTag(innerClosingTag BACnetClosingTag) BACnetPropertyValuesBuilder {
	b.InnerClosingTag = innerClosingTag
	return b
}

func (b *_BACnetPropertyValuesBuilder) WithInnerClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetPropertyValuesBuilder {
	builder := builderSupplier(b.InnerClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.InnerClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyValuesBuilder) WithArgTagNumber(tagNumber uint8) BACnetPropertyValuesBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetPropertyValuesBuilder) WithArgObjectTypeArgument(objectTypeArgument BACnetObjectType) BACnetPropertyValuesBuilder {
	b.ObjectTypeArgument = objectTypeArgument
	return b
}

func (b *_BACnetPropertyValuesBuilder) Build() (BACnetPropertyValues, error) {
	if b.InnerOpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'innerOpeningTag' not set"))
	}
	if b.InnerClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'innerClosingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetPropertyValues.deepCopy(), nil
}

func (b *_BACnetPropertyValuesBuilder) MustBuild() BACnetPropertyValues {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyValuesBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyValuesBuilder().(*_BACnetPropertyValuesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetPropertyValuesBuilder creates a BACnetPropertyValuesBuilder
func (b *_BACnetPropertyValues) CreateBACnetPropertyValuesBuilder() BACnetPropertyValuesBuilder {
	if b == nil {
		return NewBACnetPropertyValuesBuilder()
	}
	return &_BACnetPropertyValuesBuilder{_BACnetPropertyValues: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyValues) GetInnerOpeningTag() BACnetOpeningTag {
	return m.InnerOpeningTag
}

func (m *_BACnetPropertyValues) GetData() []BACnetPropertyValue {
	return m.Data
}

func (m *_BACnetPropertyValues) GetInnerClosingTag() BACnetClosingTag {
	return m.InnerClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyValues(structType any) BACnetPropertyValues {
	if casted, ok := structType.(BACnetPropertyValues); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyValues); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyValues) GetTypeName() string {
	return "BACnetPropertyValues"
}

func (m *_BACnetPropertyValues) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (innerOpeningTag)
	lengthInBits += m.InnerOpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.Data) > 0 {
		for _, element := range m.Data {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (innerClosingTag)
	lengthInBits += m.InnerClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyValues) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetPropertyValuesParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType) (BACnetPropertyValues, error) {
	return BACnetPropertyValuesParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument)
}

func BACnetPropertyValuesParseWithBufferProducer(tagNumber uint8, objectTypeArgument BACnetObjectType) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetPropertyValues, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetPropertyValues, error) {
		return BACnetPropertyValuesParseWithBuffer(ctx, readBuffer, tagNumber, objectTypeArgument)
	}
}

func BACnetPropertyValuesParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType) (BACnetPropertyValues, error) {
	v, err := (&_BACnetPropertyValues{TagNumber: tagNumber, ObjectTypeArgument: objectTypeArgument}).parse(ctx, readBuffer, tagNumber, objectTypeArgument)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetPropertyValues) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType) (__bACnetPropertyValues BACnetPropertyValues, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyValues"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyValues")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	innerOpeningTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "innerOpeningTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'innerOpeningTag' field"))
	}
	m.InnerOpeningTag = innerOpeningTag

	data, err := ReadTerminatedArrayField[BACnetPropertyValue](ctx, "data", ReadComplex[BACnetPropertyValue](BACnetPropertyValueParseWithBufferProducer((BACnetObjectType)(objectTypeArgument)), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'data' field"))
	}
	m.Data = data

	innerClosingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "innerClosingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'innerClosingTag' field"))
	}
	m.InnerClosingTag = innerClosingTag

	if closeErr := readBuffer.CloseContext("BACnetPropertyValues"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyValues")
	}

	return m, nil
}

func (m *_BACnetPropertyValues) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyValues) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetPropertyValues"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetPropertyValues")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "innerOpeningTag", m.GetInnerOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'innerOpeningTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "data", m.GetData(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'data' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "innerClosingTag", m.GetInnerClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'innerClosingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetPropertyValues"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetPropertyValues")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetPropertyValues) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetPropertyValues) GetObjectTypeArgument() BACnetObjectType {
	return m.ObjectTypeArgument
}

//
////

func (m *_BACnetPropertyValues) IsBACnetPropertyValues() {}

func (m *_BACnetPropertyValues) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyValues) deepCopy() *_BACnetPropertyValues {
	if m == nil {
		return nil
	}
	_BACnetPropertyValuesCopy := &_BACnetPropertyValues{
		utils.DeepCopy[BACnetOpeningTag](m.InnerOpeningTag),
		utils.DeepCopySlice[BACnetPropertyValue, BACnetPropertyValue](m.Data),
		utils.DeepCopy[BACnetClosingTag](m.InnerClosingTag),
		m.TagNumber,
		m.ObjectTypeArgument,
	}
	return _BACnetPropertyValuesCopy
}

func (m *_BACnetPropertyValues) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
