/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataReferencePort is the corresponding interface of BACnetConstructedDataReferencePort
type BACnetConstructedDataReferencePort interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetReferencePort returns ReferencePort (property field)
	GetReferencePort() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataReferencePort is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataReferencePort()
	// CreateBuilder creates a BACnetConstructedDataReferencePortBuilder
	CreateBACnetConstructedDataReferencePortBuilder() BACnetConstructedDataReferencePortBuilder
}

// _BACnetConstructedDataReferencePort is the data-structure of this message
type _BACnetConstructedDataReferencePort struct {
	BACnetConstructedDataContract
	ReferencePort BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataReferencePort = (*_BACnetConstructedDataReferencePort)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataReferencePort)(nil)

// NewBACnetConstructedDataReferencePort factory function for _BACnetConstructedDataReferencePort
func NewBACnetConstructedDataReferencePort(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, referencePort BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataReferencePort {
	if referencePort == nil {
		panic("referencePort of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataReferencePort must not be nil")
	}
	_result := &_BACnetConstructedDataReferencePort{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ReferencePort:                 referencePort,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataReferencePortBuilder is a builder for BACnetConstructedDataReferencePort
type BACnetConstructedDataReferencePortBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(referencePort BACnetApplicationTagUnsignedInteger) BACnetConstructedDataReferencePortBuilder
	// WithReferencePort adds ReferencePort (property field)
	WithReferencePort(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataReferencePortBuilder
	// WithReferencePortBuilder adds ReferencePort (property field) which is build by the builder
	WithReferencePortBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataReferencePortBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataReferencePort or returns an error if something is wrong
	Build() (BACnetConstructedDataReferencePort, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataReferencePort
}

// NewBACnetConstructedDataReferencePortBuilder() creates a BACnetConstructedDataReferencePortBuilder
func NewBACnetConstructedDataReferencePortBuilder() BACnetConstructedDataReferencePortBuilder {
	return &_BACnetConstructedDataReferencePortBuilder{_BACnetConstructedDataReferencePort: new(_BACnetConstructedDataReferencePort)}
}

type _BACnetConstructedDataReferencePortBuilder struct {
	*_BACnetConstructedDataReferencePort

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataReferencePortBuilder) = (*_BACnetConstructedDataReferencePortBuilder)(nil)

func (b *_BACnetConstructedDataReferencePortBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataReferencePort
}

func (b *_BACnetConstructedDataReferencePortBuilder) WithMandatoryFields(referencePort BACnetApplicationTagUnsignedInteger) BACnetConstructedDataReferencePortBuilder {
	return b.WithReferencePort(referencePort)
}

func (b *_BACnetConstructedDataReferencePortBuilder) WithReferencePort(referencePort BACnetApplicationTagUnsignedInteger) BACnetConstructedDataReferencePortBuilder {
	b.ReferencePort = referencePort
	return b
}

func (b *_BACnetConstructedDataReferencePortBuilder) WithReferencePortBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataReferencePortBuilder {
	builder := builderSupplier(b.ReferencePort.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.ReferencePort, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataReferencePortBuilder) Build() (BACnetConstructedDataReferencePort, error) {
	if b.ReferencePort == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'referencePort' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataReferencePort.deepCopy(), nil
}

func (b *_BACnetConstructedDataReferencePortBuilder) MustBuild() BACnetConstructedDataReferencePort {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataReferencePortBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataReferencePortBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataReferencePortBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataReferencePortBuilder().(*_BACnetConstructedDataReferencePortBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataReferencePortBuilder creates a BACnetConstructedDataReferencePortBuilder
func (b *_BACnetConstructedDataReferencePort) CreateBACnetConstructedDataReferencePortBuilder() BACnetConstructedDataReferencePortBuilder {
	if b == nil {
		return NewBACnetConstructedDataReferencePortBuilder()
	}
	return &_BACnetConstructedDataReferencePortBuilder{_BACnetConstructedDataReferencePort: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataReferencePort) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataReferencePort) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_REFERENCE_PORT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataReferencePort) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataReferencePort) GetReferencePort() BACnetApplicationTagUnsignedInteger {
	return m.ReferencePort
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataReferencePort) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetReferencePort())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataReferencePort(structType any) BACnetConstructedDataReferencePort {
	if casted, ok := structType.(BACnetConstructedDataReferencePort); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataReferencePort); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataReferencePort) GetTypeName() string {
	return "BACnetConstructedDataReferencePort"
}

func (m *_BACnetConstructedDataReferencePort) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (referencePort)
	lengthInBits += m.ReferencePort.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataReferencePort) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataReferencePort) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataReferencePort BACnetConstructedDataReferencePort, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataReferencePort"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataReferencePort")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	referencePort, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "referencePort", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'referencePort' field"))
	}
	m.ReferencePort = referencePort

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), referencePort)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataReferencePort"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataReferencePort")
	}

	return m, nil
}

func (m *_BACnetConstructedDataReferencePort) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataReferencePort) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataReferencePort"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataReferencePort")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "referencePort", m.GetReferencePort(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'referencePort' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataReferencePort"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataReferencePort")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataReferencePort) IsBACnetConstructedDataReferencePort() {}

func (m *_BACnetConstructedDataReferencePort) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataReferencePort) deepCopy() *_BACnetConstructedDataReferencePort {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataReferencePortCopy := &_BACnetConstructedDataReferencePort{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.ReferencePort),
	}
	_BACnetConstructedDataReferencePortCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataReferencePortCopy
}

func (m *_BACnetConstructedDataReferencePort) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
