/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLandingDoorStatusLandingDoorsListEntry is the corresponding interface of BACnetLandingDoorStatusLandingDoorsListEntry
type BACnetLandingDoorStatusLandingDoorsListEntry interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetFloorNumber returns FloorNumber (property field)
	GetFloorNumber() BACnetContextTagUnsignedInteger
	// GetDoorStatus returns DoorStatus (property field)
	GetDoorStatus() BACnetDoorStatusTagged
	// IsBACnetLandingDoorStatusLandingDoorsListEntry is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLandingDoorStatusLandingDoorsListEntry()
	// CreateBuilder creates a BACnetLandingDoorStatusLandingDoorsListEntryBuilder
	CreateBACnetLandingDoorStatusLandingDoorsListEntryBuilder() BACnetLandingDoorStatusLandingDoorsListEntryBuilder
}

// _BACnetLandingDoorStatusLandingDoorsListEntry is the data-structure of this message
type _BACnetLandingDoorStatusLandingDoorsListEntry struct {
	FloorNumber BACnetContextTagUnsignedInteger
	DoorStatus  BACnetDoorStatusTagged
}

var _ BACnetLandingDoorStatusLandingDoorsListEntry = (*_BACnetLandingDoorStatusLandingDoorsListEntry)(nil)

// NewBACnetLandingDoorStatusLandingDoorsListEntry factory function for _BACnetLandingDoorStatusLandingDoorsListEntry
func NewBACnetLandingDoorStatusLandingDoorsListEntry(floorNumber BACnetContextTagUnsignedInteger, doorStatus BACnetDoorStatusTagged) *_BACnetLandingDoorStatusLandingDoorsListEntry {
	if floorNumber == nil {
		panic("floorNumber of type BACnetContextTagUnsignedInteger for BACnetLandingDoorStatusLandingDoorsListEntry must not be nil")
	}
	if doorStatus == nil {
		panic("doorStatus of type BACnetDoorStatusTagged for BACnetLandingDoorStatusLandingDoorsListEntry must not be nil")
	}
	return &_BACnetLandingDoorStatusLandingDoorsListEntry{FloorNumber: floorNumber, DoorStatus: doorStatus}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLandingDoorStatusLandingDoorsListEntryBuilder is a builder for BACnetLandingDoorStatusLandingDoorsListEntry
type BACnetLandingDoorStatusLandingDoorsListEntryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(floorNumber BACnetContextTagUnsignedInteger, doorStatus BACnetDoorStatusTagged) BACnetLandingDoorStatusLandingDoorsListEntryBuilder
	// WithFloorNumber adds FloorNumber (property field)
	WithFloorNumber(BACnetContextTagUnsignedInteger) BACnetLandingDoorStatusLandingDoorsListEntryBuilder
	// WithFloorNumberBuilder adds FloorNumber (property field) which is build by the builder
	WithFloorNumberBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetLandingDoorStatusLandingDoorsListEntryBuilder
	// WithDoorStatus adds DoorStatus (property field)
	WithDoorStatus(BACnetDoorStatusTagged) BACnetLandingDoorStatusLandingDoorsListEntryBuilder
	// WithDoorStatusBuilder adds DoorStatus (property field) which is build by the builder
	WithDoorStatusBuilder(func(BACnetDoorStatusTaggedBuilder) BACnetDoorStatusTaggedBuilder) BACnetLandingDoorStatusLandingDoorsListEntryBuilder
	// Build builds the BACnetLandingDoorStatusLandingDoorsListEntry or returns an error if something is wrong
	Build() (BACnetLandingDoorStatusLandingDoorsListEntry, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLandingDoorStatusLandingDoorsListEntry
}

// NewBACnetLandingDoorStatusLandingDoorsListEntryBuilder() creates a BACnetLandingDoorStatusLandingDoorsListEntryBuilder
func NewBACnetLandingDoorStatusLandingDoorsListEntryBuilder() BACnetLandingDoorStatusLandingDoorsListEntryBuilder {
	return &_BACnetLandingDoorStatusLandingDoorsListEntryBuilder{_BACnetLandingDoorStatusLandingDoorsListEntry: new(_BACnetLandingDoorStatusLandingDoorsListEntry)}
}

type _BACnetLandingDoorStatusLandingDoorsListEntryBuilder struct {
	*_BACnetLandingDoorStatusLandingDoorsListEntry

	collectedErr []error
}

var _ (BACnetLandingDoorStatusLandingDoorsListEntryBuilder) = (*_BACnetLandingDoorStatusLandingDoorsListEntryBuilder)(nil)

func (b *_BACnetLandingDoorStatusLandingDoorsListEntryBuilder) WithMandatoryFields(floorNumber BACnetContextTagUnsignedInteger, doorStatus BACnetDoorStatusTagged) BACnetLandingDoorStatusLandingDoorsListEntryBuilder {
	return b.WithFloorNumber(floorNumber).WithDoorStatus(doorStatus)
}

func (b *_BACnetLandingDoorStatusLandingDoorsListEntryBuilder) WithFloorNumber(floorNumber BACnetContextTagUnsignedInteger) BACnetLandingDoorStatusLandingDoorsListEntryBuilder {
	b.FloorNumber = floorNumber
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListEntryBuilder) WithFloorNumberBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetLandingDoorStatusLandingDoorsListEntryBuilder {
	builder := builderSupplier(b.FloorNumber.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.FloorNumber, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListEntryBuilder) WithDoorStatus(doorStatus BACnetDoorStatusTagged) BACnetLandingDoorStatusLandingDoorsListEntryBuilder {
	b.DoorStatus = doorStatus
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListEntryBuilder) WithDoorStatusBuilder(builderSupplier func(BACnetDoorStatusTaggedBuilder) BACnetDoorStatusTaggedBuilder) BACnetLandingDoorStatusLandingDoorsListEntryBuilder {
	builder := builderSupplier(b.DoorStatus.CreateBACnetDoorStatusTaggedBuilder())
	var err error
	b.DoorStatus, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDoorStatusTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetLandingDoorStatusLandingDoorsListEntryBuilder) Build() (BACnetLandingDoorStatusLandingDoorsListEntry, error) {
	if b.FloorNumber == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'floorNumber' not set"))
	}
	if b.DoorStatus == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'doorStatus' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetLandingDoorStatusLandingDoorsListEntry.deepCopy(), nil
}

func (b *_BACnetLandingDoorStatusLandingDoorsListEntryBuilder) MustBuild() BACnetLandingDoorStatusLandingDoorsListEntry {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLandingDoorStatusLandingDoorsListEntryBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLandingDoorStatusLandingDoorsListEntryBuilder().(*_BACnetLandingDoorStatusLandingDoorsListEntryBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetLandingDoorStatusLandingDoorsListEntryBuilder creates a BACnetLandingDoorStatusLandingDoorsListEntryBuilder
func (b *_BACnetLandingDoorStatusLandingDoorsListEntry) CreateBACnetLandingDoorStatusLandingDoorsListEntryBuilder() BACnetLandingDoorStatusLandingDoorsListEntryBuilder {
	if b == nil {
		return NewBACnetLandingDoorStatusLandingDoorsListEntryBuilder()
	}
	return &_BACnetLandingDoorStatusLandingDoorsListEntryBuilder{_BACnetLandingDoorStatusLandingDoorsListEntry: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) GetFloorNumber() BACnetContextTagUnsignedInteger {
	return m.FloorNumber
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) GetDoorStatus() BACnetDoorStatusTagged {
	return m.DoorStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLandingDoorStatusLandingDoorsListEntry(structType any) BACnetLandingDoorStatusLandingDoorsListEntry {
	if casted, ok := structType.(BACnetLandingDoorStatusLandingDoorsListEntry); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLandingDoorStatusLandingDoorsListEntry); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) GetTypeName() string {
	return "BACnetLandingDoorStatusLandingDoorsListEntry"
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (floorNumber)
	lengthInBits += m.FloorNumber.GetLengthInBits(ctx)

	// Simple field (doorStatus)
	lengthInBits += m.DoorStatus.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLandingDoorStatusLandingDoorsListEntryParse(ctx context.Context, theBytes []byte) (BACnetLandingDoorStatusLandingDoorsListEntry, error) {
	return BACnetLandingDoorStatusLandingDoorsListEntryParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetLandingDoorStatusLandingDoorsListEntryParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLandingDoorStatusLandingDoorsListEntry, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLandingDoorStatusLandingDoorsListEntry, error) {
		return BACnetLandingDoorStatusLandingDoorsListEntryParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetLandingDoorStatusLandingDoorsListEntryParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLandingDoorStatusLandingDoorsListEntry, error) {
	v, err := (&_BACnetLandingDoorStatusLandingDoorsListEntry{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetLandingDoorStatusLandingDoorsListEntry BACnetLandingDoorStatusLandingDoorsListEntry, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLandingDoorStatusLandingDoorsListEntry"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLandingDoorStatusLandingDoorsListEntry")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	floorNumber, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "floorNumber", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(0)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'floorNumber' field"))
	}
	m.FloorNumber = floorNumber

	doorStatus, err := ReadSimpleField[BACnetDoorStatusTagged](ctx, "doorStatus", ReadComplex[BACnetDoorStatusTagged](BACnetDoorStatusTaggedParseWithBufferProducer((uint8)(uint8(1)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'doorStatus' field"))
	}
	m.DoorStatus = doorStatus

	if closeErr := readBuffer.CloseContext("BACnetLandingDoorStatusLandingDoorsListEntry"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLandingDoorStatusLandingDoorsListEntry")
	}

	return m, nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLandingDoorStatusLandingDoorsListEntry"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLandingDoorStatusLandingDoorsListEntry")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "floorNumber", m.GetFloorNumber(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'floorNumber' field")
	}

	if err := WriteSimpleField[BACnetDoorStatusTagged](ctx, "doorStatus", m.GetDoorStatus(), WriteComplex[BACnetDoorStatusTagged](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'doorStatus' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLandingDoorStatusLandingDoorsListEntry"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLandingDoorStatusLandingDoorsListEntry")
	}
	return nil
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) IsBACnetLandingDoorStatusLandingDoorsListEntry() {
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) deepCopy() *_BACnetLandingDoorStatusLandingDoorsListEntry {
	if m == nil {
		return nil
	}
	_BACnetLandingDoorStatusLandingDoorsListEntryCopy := &_BACnetLandingDoorStatusLandingDoorsListEntry{
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.FloorNumber),
		utils.DeepCopy[BACnetDoorStatusTagged](m.DoorStatus),
	}
	return _BACnetLandingDoorStatusLandingDoorsListEntryCopy
}

func (m *_BACnetLandingDoorStatusLandingDoorsListEntry) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
