/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetBackupStateTagged is the corresponding interface of BACnetBackupStateTagged
type BACnetBackupStateTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetBackupState
	// IsBACnetBackupStateTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetBackupStateTagged()
	// CreateBuilder creates a BACnetBackupStateTaggedBuilder
	CreateBACnetBackupStateTaggedBuilder() BACnetBackupStateTaggedBuilder
}

// _BACnetBackupStateTagged is the data-structure of this message
type _BACnetBackupStateTagged struct {
	Header BACnetTagHeader
	Value  BACnetBackupState

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetBackupStateTagged = (*_BACnetBackupStateTagged)(nil)

// NewBACnetBackupStateTagged factory function for _BACnetBackupStateTagged
func NewBACnetBackupStateTagged(header BACnetTagHeader, value BACnetBackupState, tagNumber uint8, tagClass TagClass) *_BACnetBackupStateTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetBackupStateTagged must not be nil")
	}
	return &_BACnetBackupStateTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetBackupStateTaggedBuilder is a builder for BACnetBackupStateTagged
type BACnetBackupStateTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetBackupState) BACnetBackupStateTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetBackupStateTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetBackupStateTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetBackupState) BACnetBackupStateTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetBackupStateTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetBackupStateTaggedBuilder
	// Build builds the BACnetBackupStateTagged or returns an error if something is wrong
	Build() (BACnetBackupStateTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetBackupStateTagged
}

// NewBACnetBackupStateTaggedBuilder() creates a BACnetBackupStateTaggedBuilder
func NewBACnetBackupStateTaggedBuilder() BACnetBackupStateTaggedBuilder {
	return &_BACnetBackupStateTaggedBuilder{_BACnetBackupStateTagged: new(_BACnetBackupStateTagged)}
}

type _BACnetBackupStateTaggedBuilder struct {
	*_BACnetBackupStateTagged

	collectedErr []error
}

var _ (BACnetBackupStateTaggedBuilder) = (*_BACnetBackupStateTaggedBuilder)(nil)

func (b *_BACnetBackupStateTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetBackupState) BACnetBackupStateTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetBackupStateTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetBackupStateTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetBackupStateTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetBackupStateTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetBackupStateTaggedBuilder) WithValue(value BACnetBackupState) BACnetBackupStateTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetBackupStateTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetBackupStateTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetBackupStateTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetBackupStateTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetBackupStateTaggedBuilder) Build() (BACnetBackupStateTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetBackupStateTagged.deepCopy(), nil
}

func (b *_BACnetBackupStateTaggedBuilder) MustBuild() BACnetBackupStateTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetBackupStateTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetBackupStateTaggedBuilder().(*_BACnetBackupStateTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetBackupStateTaggedBuilder creates a BACnetBackupStateTaggedBuilder
func (b *_BACnetBackupStateTagged) CreateBACnetBackupStateTaggedBuilder() BACnetBackupStateTaggedBuilder {
	if b == nil {
		return NewBACnetBackupStateTaggedBuilder()
	}
	return &_BACnetBackupStateTaggedBuilder{_BACnetBackupStateTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetBackupStateTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetBackupStateTagged) GetValue() BACnetBackupState {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetBackupStateTagged(structType any) BACnetBackupStateTagged {
	if casted, ok := structType.(BACnetBackupStateTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetBackupStateTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetBackupStateTagged) GetTypeName() string {
	return "BACnetBackupStateTagged"
}

func (m *_BACnetBackupStateTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetBackupStateTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetBackupStateTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetBackupStateTagged, error) {
	return BACnetBackupStateTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetBackupStateTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetBackupStateTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetBackupStateTagged, error) {
		return BACnetBackupStateTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetBackupStateTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetBackupStateTagged, error) {
	v, err := (&_BACnetBackupStateTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetBackupStateTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetBackupStateTagged BACnetBackupStateTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetBackupStateTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetBackupStateTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetBackupState](ctx, "value", readBuffer, EnsureType[BACnetBackupState](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetBackupState_IDLE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetBackupStateTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetBackupStateTagged")
	}

	return m, nil
}

func (m *_BACnetBackupStateTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetBackupStateTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetBackupStateTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetBackupStateTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetBackupState](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetBackupStateTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetBackupStateTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetBackupStateTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetBackupStateTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetBackupStateTagged) IsBACnetBackupStateTagged() {}

func (m *_BACnetBackupStateTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetBackupStateTagged) deepCopy() *_BACnetBackupStateTagged {
	if m == nil {
		return nil
	}
	_BACnetBackupStateTaggedCopy := &_BACnetBackupStateTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetBackupStateTaggedCopy
}

func (m *_BACnetBackupStateTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
