/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.JceKEM;
import org.apache.sshd.common.util.security.KEM;
import org.apache.sshd.common.util.security.SecurityEntityFactory;
import org.apache.sshd.common.util.security.SecurityUtils;

public class SunJCESecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    private final Map<String, String> defaultProperties = new HashMap<String, String>();

    public SunJCESecurityProviderRegistrar() {
        super("SunJCEWrapper");
        String baseName = this.getBasePropertyName();
        this.defaultProperties.put(baseName + ".Cipher", "AES");
        this.defaultProperties.put(baseName + ".Mac", "HmacSha1,HmacSha224,HmacSha256,HmacSha384,HmacSha512");
        if (this.isSupported() && SunJCESecurityProviderRegistrar.haveKEM(this.getSecurityProvider())) {
            String kems = "ML-KEM-1024,ML-KEM-768";
            this.defaultProperties.put(baseName + ".KEM", kems);
            this.defaultProperties.put(baseName + ".KeyPairGenerator", kems);
            this.defaultProperties.put(baseName + ".KeyFactory", kems);
        }
    }

    private static boolean haveKEM(Provider provider) {
        try {
            KeyFactory factory = KeyFactory.getInstance("ML-KEM-768", provider);
            return factory != null;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    @Override
    public boolean isEnabled() {
        if (SecurityUtils.isFipsMode() || !super.isEnabled()) {
            return false;
        }
        return this.isSupported();
    }

    @Override
    public String getProviderName() {
        return "SunJCE";
    }

    @Override
    public String getDefaultSecurityEntitySupportValue(Class<?> entityType) {
        return "";
    }

    @Override
    public String getString(String name) {
        String byDefault;
        String configured = super.getString(name);
        if (GenericUtils.isEmpty(configured) && (byDefault = this.defaultProperties.get(name)) != null) {
            return byDefault;
        }
        return configured;
    }

    @Override
    public boolean isNamedProviderUsed() {
        return false;
    }

    @Override
    public Provider getSecurityProvider() {
        return Security.getProvider(this.getProviderName());
    }

    @Override
    public boolean isSupported() {
        return this.getSecurityProvider() != null;
    }

    @Override
    public SecurityEntityFactory getFactory() {
        return new SecurityEntityFactory.ByProvider(this.getSecurityProvider()){

            @Override
            public KEM createKEM(String algorithm) throws GeneralSecurityException {
                return JceKEM.INSTANCE.get(algorithm);
            }
        };
    }
}

