/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.GeocentricAffine;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public abstract class GeocentricAffineBetweenGeographic
extends GeocentricAffine {
    private static final long serialVersionUID = -6202315859507526222L;
    public static final ParameterDescriptor<Integer> DIMENSION;
    public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR;
    public static final ParameterDescriptor<Double> SRC_SEMI_MINOR;
    public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR;
    public static final ParameterDescriptor<Double> TGT_SEMI_MINOR;

    @Deprecated
    GeocentricAffineBetweenGeographic(GeocentricAffineBetweenGeographic copy) {
        super(copy);
    }

    GeocentricAffineBetweenGeographic(GeocentricAffine.Type operationType, ParameterDescriptorGroup parameters, int indexOfDim) {
        super(operationType, parameters, indexOfDim, EllipsoidalCS.class, true, EllipsoidalCS.class, true);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        Parameters pv = Parameters.castOrWrap(values);
        MathTransform affine = super.createMathTransform(factory, pv);
        MathTransform toGeocentric = EllipsoidToCentricTransform.createGeodeticConversion(factory, pv.doubleValue(SRC_SEMI_MAJOR), pv.doubleValue(SRC_SEMI_MINOR), Units.METRE, this.getSourceDimensions() >= 3, EllipsoidToCentricTransform.TargetType.CARTESIAN);
        MathTransform toGeographic = EllipsoidToCentricTransform.createGeodeticConversion(factory, pv.doubleValue(TGT_SEMI_MAJOR), pv.doubleValue(TGT_SEMI_MINOR), Units.METRE, this.getTargetDimensions() >= 3, EllipsoidToCentricTransform.TargetType.CARTESIAN);
        try {
            toGeographic = toGeographic.inverse();
        }
        catch (NoninvertibleTransformException e2) {
            throw new FactoryException(e2);
        }
        return factory.createConcatenatedTransform(toGeocentric, factory.createConcatenatedTransform(affine, toGeographic));
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)GeocentricAffineBetweenGeographic.builder().setCodeSpace(Citations.OGC, "OGC");
        SRC_SEMI_MAJOR = ((ParameterBuilder)builder.addName("src_semi_major")).createStrictlyPositive(Double.NaN, Units.METRE);
        SRC_SEMI_MINOR = ((ParameterBuilder)builder.addName("src_semi_minor")).createStrictlyPositive(Double.NaN, Units.METRE);
        TGT_SEMI_MAJOR = ((ParameterBuilder)builder.addName("tgt_semi_major")).createStrictlyPositive(Double.NaN, Units.METRE);
        TGT_SEMI_MINOR = ((ParameterBuilder)builder.addName("tgt_semi_minor")).createStrictlyPositive(Double.NaN, Units.METRE);
        DIMENSION = ((ParameterBuilder)builder.addName("dim")).setRequired(false).createBounded(Integer.class, Integer.valueOf(2), Integer.valueOf(3), null);
    }
}

