/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorDelayedInitialization;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;

public class QueryIterGroup
extends QueryIterPlainWrapper {
    private final QueryIterator embeddedIterator;
    private static Pair<Var, Accumulator> placeholder = Pair.create(null, null);

    public QueryIterGroup(QueryIterator qIter, VarExprList groupVars, List<ExprAggregator> aggregators, ExecutionContext execCxt) {
        super(QueryIterGroup.calc(qIter, groupVars, aggregators, execCxt), execCxt);
        this.embeddedIterator = qIter;
    }

    @Override
    public void requestCancel() {
        this.embeddedIterator.cancel();
        super.requestCancel();
    }

    @Override
    protected void closeIterator() {
        this.embeddedIterator.close();
        super.closeIterator();
    }

    private static Iterator<Binding> calc(final QueryIterator iter, final VarExprList groupVarExpr, final List<ExprAggregator> aggregators, final ExecutionContext execCxt) {
        return new IteratorDelayedInitialization<Binding>(){

            @Override
            protected Iterator<Binding> initializeIterator() {
                boolean noInput;
                boolean hasAggregators = aggregators != null && !aggregators.isEmpty();
                boolean hasGroupBy = !groupVarExpr.isEmpty();
                boolean bl = noInput = !iter.hasNext();
                if (noInput) {
                    if (hasGroupBy) {
                        return Iter.nullIterator();
                    }
                    if (!hasAggregators) {
                        return Iter.singletonIterator(BindingFactory.binding());
                    }
                    BindingBuilder builder = Binding.builder();
                    for (ExprAggregator agg : aggregators) {
                        Node value = agg.getAggregator().getValueEmpty();
                        if (value == null) continue;
                        Var v = agg.getVar();
                        builder.add(v, value);
                    }
                    return Iter.singletonIterator(builder.build());
                }
                ListValuedMap<Binding, Pair<Var, Accumulator>> accumulators = MultiMapUtils.newListValuedHashMap();
                while (iter.hasNext()) {
                    Binding b = iter.nextBinding();
                    Binding key = QueryIterGroup.genKey(groupVarExpr, b, execCxt);
                    if (!hasAggregators) {
                        accumulators.put(key, placeholder);
                        continue;
                    }
                    if (!accumulators.containsKey(key)) {
                        for (ExprAggregator agg : aggregators) {
                            Accumulator x = agg.getAggregator().createAccumulator();
                            Var v = agg.getVar();
                            accumulators.put(key, Pair.create(v, x));
                        }
                    }
                    for (Pair pair : accumulators.get(key)) {
                        ((Accumulator)pair.getRight()).accumulate(b, execCxt);
                    }
                }
                if (!hasAggregators) {
                    return accumulators.keySet().iterator();
                }
                ArrayList<Binding> results = new ArrayList<Binding>();
                for (Binding k : accumulators.keySet()) {
                    BindingBuilder builder2 = Binding.builder(k);
                    Collection accs = accumulators.get(k);
                    for (Pair pair : accs) {
                        NodeValue value = ((Accumulator)pair.getRight()).getValue();
                        if (value == null) continue;
                        Var v = (Var)pair.getLeft();
                        builder2.add(v, value.asNode());
                    }
                    results.add(builder2.build());
                }
                return results.iterator();
            }
        };
    }

    private static Binding genKey(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        return QueryIterGroup.copyProject(vars, binding, execCxt);
    }

    private static Binding copyProject(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        BindingBuilder x = Binding.builder();
        for (Var var : vars.getVars()) {
            Node node = vars.get(var, binding, execCxt);
            if (node == null) continue;
            x.add(var, node);
        }
        return x.build();
    }
}

