/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation;

import org.apache.jena.geosparql.implementation.datatype.WKTDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sys.JenaSystem;

public class WKTLiteralFactory {
    public static final Literal createPoint(Double x, Double y) {
        return WKTLiteralFactory.createPoint(x, y, "");
    }

    public static final Literal createPoint(Double x, Double y, String srsURI) {
        String tidyURI = WKTLiteralFactory.tidySrsURI(srsURI);
        return ResourceFactory.createTypedLiteral(tidyURI + "POINT(" + WKTLiteralFactory.reducePrecision(x) + " " + WKTLiteralFactory.reducePrecision(y) + ")", WKTDatatype.INSTANCE);
    }

    public static final Literal createLineString(Double xMin, Double yMin, Double xMax, Double yMax) {
        return WKTLiteralFactory.createLineString(xMin, yMin, xMax, yMax, "");
    }

    public static final Literal createLineString(Double xMin, Double yMin, Double xMax, Double yMax, String srsURI) {
        String tidyURI = WKTLiteralFactory.tidySrsURI(srsURI);
        return ResourceFactory.createTypedLiteral(tidyURI + "LINESTRING(" + WKTLiteralFactory.reducePrecision(xMin) + " " + WKTLiteralFactory.reducePrecision(yMin) + ", " + WKTLiteralFactory.reducePrecision(xMax) + " " + WKTLiteralFactory.reducePrecision(yMax) + ")", WKTDatatype.INSTANCE);
    }

    public static final Literal createBox(Double xMin, Double yMin, Double xMax, Double yMax) {
        return WKTLiteralFactory.createLineString(xMin, yMin, xMax, yMax, "");
    }

    public static final Literal createBox(Double xMin, Double yMin, Double xMax, Double yMax, String srsURI) {
        String tidyURI = WKTLiteralFactory.tidySrsURI(srsURI);
        return ResourceFactory.createTypedLiteral(tidyURI + "POLYGON((" + WKTLiteralFactory.reducePrecision(xMin) + " " + WKTLiteralFactory.reducePrecision(yMin) + ", " + WKTLiteralFactory.reducePrecision(xMax) + " " + WKTLiteralFactory.reducePrecision(yMin) + ", " + WKTLiteralFactory.reducePrecision(xMax) + " " + WKTLiteralFactory.reducePrecision(yMax) + ", " + WKTLiteralFactory.reducePrecision(xMin) + " " + WKTLiteralFactory.reducePrecision(yMax) + ", " + WKTLiteralFactory.reducePrecision(xMin) + " " + WKTLiteralFactory.reducePrecision(yMin) + "))", WKTDatatype.INSTANCE);
    }

    private static String tidySrsURI(String srsURI) {
        Object tidyURI = !srsURI.isEmpty() ? "<" + srsURI + "> " : "";
        return tidyURI;
    }

    public static final String reducePrecision(Double value) {
        long longValue = value.longValue();
        if (value == (double)longValue) {
            return Long.toString(longValue);
        }
        return value.toString();
    }

    static {
        JenaSystem.init();
    }
}

