/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.geosparql;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.sys.FusekiAutoModule;
import org.apache.jena.fuseki.mod.geosparql.SpatialIndexerService;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.rdf.model.Model;

public class FMod_SpatialIndexer
implements FusekiAutoModule {
    public static Operation spatialIndexerOperation = Operation.alloc("http://jena.apache.org/fuseki#spatial-indexer", "spatial-indexer", "Spatial indexer service");

    @Override
    public String name() {
        return "Spatial Indexer";
    }

    @Override
    public void start() {
    }

    @Override
    public void prepare(FusekiServer.Builder builder, Set<String> datasetNames, Model configModel) {
        Fuseki.configLog.info(this.name() + ": Registering operation " + String.valueOf(spatialIndexerOperation.getId()));
        builder.registerOperation(spatialIndexerOperation, new SpatialIndexerService());
    }

    @Override
    public void configured(FusekiServer.Builder serverBuilder, DataAccessPointRegistry dapRegistry, Model configModel) {
        FusekiAutoModule.super.configured(serverBuilder, dapRegistry, configModel);
        boolean autoConfigure = false;
        if (autoConfigure) {
            this.autoConfigure(serverBuilder, dapRegistry, configModel);
        }
    }

    private void autoConfigure(FusekiServer.Builder serverBuilder, DataAccessPointRegistry dapRegistry, Model configModel) {
        FusekiAutoModule.super.configured(serverBuilder, dapRegistry, configModel);
        ArrayList<DataAccessPoint> newDataAccessPoints = new ArrayList<DataAccessPoint>();
        for (DataAccessPoint dap2 : dapRegistry.accessPoints()) {
            String dapName = dap2.getName();
            String logPrefix = this.name() + " - " + dapName + ": ";
            DataService dataService = dap2.getDataService();
            List updateEndpoints = Optional.ofNullable(dataService.getEndpoints(Operation.Update)).orElse(List.of());
            ArrayList<Endpoint> spatialEndpoints = new ArrayList<Endpoint>();
            for (Endpoint updateEndpoint : updateEndpoints) {
                String updateEndpointName = updateEndpoint.getName();
                String geoIndexerEndpointName = updateEndpointName + "-spatial";
                AuthPolicy authPolicy = updateEndpoint.getAuthPolicy();
                Fuseki.configLog.info(logPrefix + "Registering spatial indexer endpoint: " + geoIndexerEndpointName);
                Endpoint geoIndexerEndpoint = Endpoint.create().operation(spatialIndexerOperation).endpointName(geoIndexerEndpointName).authPolicy(authPolicy).build();
                spatialEndpoints.add(geoIndexerEndpoint);
            }
            DataService.Builder dSrvBuilder = DataService.newBuilder(dataService);
            spatialEndpoints.forEach(dSrvBuilder::addEndpoint);
            DataService newDataService = dSrvBuilder.build();
            newDataAccessPoints.add(new DataAccessPoint(dapName, newDataService));
        }
        newDataAccessPoints.forEach(dap -> {
            dapRegistry.remove(dap.getName());
            dapRegistry.register((DataAccessPoint)dap);
        });
    }
}

