/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.access.AccessCtl_AllowGET;
import org.apache.jena.fuseki.access.AccessCtl_Deny;
import org.apache.jena.fuseki.access.AccessCtl_GSP_R;
import org.apache.jena.fuseki.access.AccessCtl_SPARQL_QueryDataset;
import org.apache.jena.fuseki.build.FusekiConfig;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.server.OperationRegistry;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.GSP_RW;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.rdf.model.Model;

public class FusekiLib {
    public static Collection<String> names(FusekiServer server) {
        DataAccessPointRegistry dataAccessPoints = DataAccessPointRegistry.get(server.getServletContext());
        int N = dataAccessPoints.size();
        Stream stream = DataAccessPointRegistry.get(server.getServletContext()).keys().stream();
        List names = stream.collect(Collectors.toCollection(() -> new ArrayList(N)));
        return names;
    }

    public static void reload(FusekiServer server, Model configuration) {
        DataAccessPointRegistry newRegistry = new DataAccessPointRegistry();
        OperationRegistry operationRegistry = server.getOperationRegistry();
        try {
            List<DataAccessPoint> newDAPs = FusekiConfig.servicesAndDatasets(configuration.getGraph());
            newDAPs.forEach(dap -> newRegistry.register((DataAccessPoint)dap));
            FusekiServer.Builder.prepareDataServices(newRegistry, operationRegistry);
            FusekiLib.setDataAccessPointRegistry(server, newRegistry);
        }
        catch (RuntimeException ex) {
            Log.error(Fuseki.serverLog, "Failed to load a new configuration", ex);
        }
    }

    public static void setDataAccessPointRegistry(FusekiServer server, DataAccessPointRegistry newRegistry) {
        Objects.requireNonNull(server, "server");
        Objects.requireNonNull(newRegistry, "newRegistry");
        ServletContext cxt = server.getServletContext();
        DataAccessPointRegistry.set(cxt, newRegistry);
    }

    public static FusekiServer.Builder fusekiBuilderAccessCtl(Function<HttpAction, String> determineUser) {
        FusekiServer.Builder builder = FusekiServer.create();
        return FusekiLib.fusekiBuilderAccessCtl(builder, determineUser);
    }

    public static FusekiServer.Builder fusekiBuilderAccessCtl(FusekiServer.Builder builder, Function<HttpAction, String> determineUser) {
        builder.registerOperation(Operation.Query, "application/sparql-query", new AccessCtl_SPARQL_QueryDataset(determineUser));
        builder.registerOperation(Operation.GSP_R, new AccessCtl_GSP_R(determineUser));
        builder.registerOperation(Operation.Update, "application/sparql-update", new AccessCtl_Deny("Update"));
        builder.registerOperation(Operation.GSP_RW, new AccessCtl_AllowGET(new GSP_RW(), "GSP Write"));
        builder.registerOperation(Operation.GSP_RW, new AccessCtl_GSP_R(determineUser));
        return builder;
    }

    public static void modifyForAccessCtl(DataAccessPointRegistry dapRegistry, Function<HttpAction, String> determineUser) {
        dapRegistry.forEach((name, dap) -> dap.getDataService().forEachEndpoint(ep -> FusekiLib.modifyForAccessCtl(ep, determineUser)));
    }

    public static void modifyForAccessCtl(Endpoint endpoint, Function<HttpAction, String> determineUser) {
        endpoint.setProcessor(FusekiLib.controlledProc(endpoint.getOperation(), determineUser));
    }

    private static ActionService controlledProc(Operation op, Function<HttpAction, String> determineUser) {
        if (Operation.Query.equals(op)) {
            return new AccessCtl_SPARQL_QueryDataset(determineUser);
        }
        if (Operation.GSP_R.equals(op)) {
            return new AccessCtl_GSP_R(determineUser);
        }
        if (Operation.GSP_RW.equals(op)) {
            return new AccessCtl_GSP_R(determineUser);
        }
        return new AccessCtl_Deny("Not supported for graph level access control: " + op.getDescription());
    }
}

