/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.datatypes;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.shared.JenaException;

public class DatatypeFormatException
extends JenaException {
    private final String lexicalForm;
    private final RDFDatatype dataType;

    public DatatypeFormatException(String lexicalForm, RDFDatatype dtype, Throwable cause) {
        super(String.format("Lexical form '%s' is not a legal instance of %s.", lexicalForm, dtype), cause);
        this.lexicalForm = lexicalForm;
        this.dataType = dtype;
    }

    public DatatypeFormatException(String lexicalForm, RDFDatatype dtype, String message) {
        super(String.format("Lexical form '%s' is not a legal instance of %s %s", lexicalForm, dtype, message));
        this.lexicalForm = lexicalForm;
        this.dataType = dtype;
    }

    public DatatypeFormatException() {
        this.lexicalForm = null;
        this.dataType = null;
    }

    public DatatypeFormatException(String message, Throwable cause) {
        super(message, cause);
        this.lexicalForm = null;
        this.dataType = null;
    }

    public DatatypeFormatException(String message) {
        super(message);
        this.lexicalForm = null;
        this.dataType = null;
    }

    public String getLexicalForm() {
        return this.lexicalForm;
    }

    public RDFDatatype getDataType() {
        return this.dataType;
    }
}

