/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.discovery;

import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class DiscoveryLocalJoinData {
    private final DiscoveryEvent evt;
    private final DiscoCache discoCache;
    private final AffinityTopologyVersion joinTopVer;
    private final IgniteInternalFuture<Boolean> transitionWaitFut;
    private final boolean active;

    public DiscoveryLocalJoinData(DiscoveryEvent evt, DiscoCache discoCache, @Nullable IgniteInternalFuture<Boolean> transitionWaitFut, boolean active) {
        assert (evt != null && evt.topologyVersion() > 0L) : evt;
        this.evt = evt;
        this.discoCache = discoCache;
        this.transitionWaitFut = transitionWaitFut;
        this.active = active;
        this.joinTopVer = new AffinityTopologyVersion(evt.topologyVersion(), 0);
    }

    @Nullable
    public IgniteInternalFuture<Boolean> transitionWaitFuture() {
        return this.transitionWaitFut;
    }

    public boolean active() {
        return this.active;
    }

    public DiscoveryEvent event() {
        return this.evt;
    }

    public DiscoCache discoCache() {
        return this.discoCache;
    }

    public AffinityTopologyVersion joinTopologyVersion() {
        return this.joinTopVer;
    }

    public String toString() {
        return S.toString(DiscoveryLocalJoinData.class, this);
    }
}

