/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.com.caucho.hessian.io.uuid;


import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class BadExampleDTO implements Serializable {
    private Long id;
    private UUID sign;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UUID getSign() {
        return sign;
    }

    public void setSign(UUID sign) {
        this.sign = sign;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) return true;
        if (object == null || getClass() != object.getClass()) return false;
        BadExampleDTO that = (BadExampleDTO) object;
        return Objects.equals(id, that.id) && Objects.equals(sign, that.sign);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, sign);
    }

    @Override
    public String toString() {
        return "ExampleDTO{" +
                "id=" + id +
                ", sign=" + sign +
                '}';
    }
}

