/**
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.kerby.kerberos.provider.token;

import org.apache.kerby.kerberos.kerb.provider.TokenDecoder;
import org.apache.kerby.kerberos.kerb.provider.TokenEncoder;
import org.apache.kerby.kerberos.kerb.provider.TokenFactory;
import org.apache.kerby.kerberos.kerb.provider.TokenProvider;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;

/**
 * JWT Token provider.
 */
public class JwtTokenProvider implements TokenProvider {

    /**
     * {@inheritDoc}
     */
    @Override
    public String getTokenType() {
        return "JWT";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TokenEncoder createTokenEncoder() {
        return new JwtTokenEncoder();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TokenDecoder createTokenDecoder() {
        return new JwtTokenDecoder();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TokenFactory createTokenFactory() {
        return new TokenFactory() {
            @Override
            public AuthToken createToken() {
                return new JwtAuthToken();
            }
        };
    }

}
