/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import org.apache.commons.io.output.NullWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NullWriterTest {
    private static final String TEST_STRING = "ABC";
    private static final char[] TEST_CHARS = "ABC".toCharArray();

    NullWriterTest() {
    }

    @Test
    void testAppendChar() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            Assertions.assertSame((Object)writer, (Object)writer.append('X'));
        }
    }

    @Test
    void testAppendCharSequence() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            Assertions.assertSame((Object)writer, (Object)writer.append((CharSequence)TEST_STRING));
            Assertions.assertSame((Object)writer, (Object)writer.append(null));
        }
    }

    @Test
    void testAppendCharSequenceWithRange() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            Assertions.assertSame((Object)writer, (Object)writer.append((CharSequence)TEST_STRING, 1, 2));
            Assertions.assertSame((Object)writer, (Object)writer.append(null, 0, 4));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.append((CharSequence)TEST_STRING, -1, 2));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.append((CharSequence)TEST_STRING, 1, 5));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.append((CharSequence)TEST_STRING, 2, 1));
        }
    }

    @Test
    void testCloseNoOp() {
        NullWriter writer = NullWriter.INSTANCE;
        writer.close();
        writer.write(TEST_CHARS);
    }

    @Test
    void testFlush() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            writer.flush();
        }
    }

    @Test
    void testWriteCharArray() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            writer.write(TEST_CHARS);
            Assertions.assertThrows(NullPointerException.class, () -> writer.write((char[])null));
        }
    }

    @Test
    void testWriteCharArrayWithOffset() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            writer.write(TEST_CHARS, 1, 2);
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.write(TEST_CHARS, -1, 0));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.write(TEST_CHARS, 0, -1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.write(TEST_CHARS, 0, 4));
            Assertions.assertThrows(NullPointerException.class, () -> writer.write((char[])null, 0, 0));
        }
    }

    @Test
    void testWriteInt() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            writer.write(42);
        }
    }

    @Test
    void testWriteString() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            writer.write(TEST_STRING);
            Assertions.assertThrows(NullPointerException.class, () -> writer.write((String)null));
        }
    }

    @Test
    void testWriteStringWithOffset() {
        try (NullWriter writer = NullWriter.INSTANCE;){
            writer.write(TEST_STRING, 1, 1);
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.write(TEST_STRING, -1, 0));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.write(TEST_STRING, 0, -1));
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> writer.write(TEST_STRING, 0, 4));
            Assertions.assertThrows(NullPointerException.class, () -> writer.write((String)null, 0, 0));
        }
    }
}

