/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Collection;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.server.ServerRuntimeBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionListener;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionalOperation;

public class ServerRuntime
extends CayenneRuntime {
    public static ServerRuntimeBuilder builder() {
        return new ServerRuntimeBuilder(null);
    }

    public static ServerRuntimeBuilder builder(String name) {
        return new ServerRuntimeBuilder(name);
    }

    protected ServerRuntime(Collection<Module> modules) {
        super(modules);
    }

    public <T> T performInTransaction(TransactionalOperation<T> op) {
        TransactionManager tm = this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op);
    }

    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionListener callback) {
        TransactionManager tm = this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op, callback);
    }

    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionDescriptor descriptor) {
        TransactionManager tm = this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op, descriptor);
    }

    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionListener callback, TransactionDescriptor descriptor) {
        TransactionManager tm = this.injector.getInstance(TransactionManager.class);
        return tm.performInTransaction(op, callback, descriptor);
    }

    public DataDomain getDataDomain() {
        return this.injector.getInstance(DataDomain.class);
    }

    public DataSource getDataSource() {
        DataDomain domain = this.getDataDomain();
        DataNode defaultNode = domain.getDefaultNode();
        if (defaultNode == null) {
            int s = domain.getDataNodes().size();
            if (s == 0) {
                throw new IllegalStateException("No DataSources configured");
            }
            throw new IllegalArgumentException("No default DataSource configured. You can get explicitly named DataSource by using 'getDataSource(String)'");
        }
        return defaultNode.getDataSource();
    }

    public DataSource getDataSource(String dataNodeName) {
        DataDomain domain = this.getDataDomain();
        if (dataNodeName == null) {
            return this.getDataSource();
        }
        DataNode node = domain.getDataNode(dataNodeName);
        if (node == null) {
            throw new IllegalArgumentException("Unknown DataNode name: " + dataNodeName);
        }
        return node.getDataSource();
    }
}

